

<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1>Welcome, <?php echo e($user->name); ?>!</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


<div class="row d-none d-md-flex">
    <div class="col-md-12">
        <div class="card card-widget widget-user">
            <div class="widget-user-header bg-gradient-primary">
                <h3 class="widget-user-username"><?php echo e($user->name); ?></h3>
                <h5 class="widget-user-desc"><?php echo e($user->email); ?></h5>
            </div>
            <?php if($employee && $employee->photo): ?>
                <div class="widget-user-image">
                    <img class="img-circle elevation-2" src="<?php echo e(asset('storage/' . $employee->photo)); ?>" alt="User Avatar">
                </div>
            <?php else: ?>
                <div class="widget-user-image">
                    <img class="img-circle elevation-2" src="<?php echo e(asset('vendor/adminlte/dist/img/user2-160x160.jpg')); ?>" alt="User Avatar">
                </div>
            <?php endif; ?>
            <div class="card-footer">
                <div class="row">
                    <div class="col-sm-4 border-right">
                        <div class="description-block">
                            <h5 class="description-header"><?php echo e($employee->employee_id ?? 'N/A'); ?></h5>
                            <span class="description-text">EMPLOYEE ID</span>
                        </div>
                    </div>
                    <div class="col-sm-4 border-right">
                        <div class="description-block">
                            <h5 class="description-header"><?php echo e($employee->department->name ?? 'N/A'); ?></h5>
                            <span class="description-text">DEPARTMENT</span>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="description-block">
                            <h5 class="description-header"><?php echo e($employee->designation->name ?? 'N/A'); ?></h5>
                            <span class="description-text">DESIGNATION</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="row d-md-none">
    <div class="col-12">
        <div class="card bg-gradient-primary">
            <div class="card-body text-center text-white">
                <?php if($employee && $employee->photo): ?>
                    <img class="img-circle elevation-2 mb-3" src="<?php echo e(asset('storage/' . $employee->photo)); ?>" alt="User Avatar" style="width: 100px; height: 100px;">
                <?php else: ?>
                    <img class="img-circle elevation-2 mb-3" src="<?php echo e(asset('vendor/adminlte/dist/img/user2-160x160.jpg')); ?>" alt="User Avatar" style="width: 100px; height: 100px;">
                <?php endif; ?>
                <h4 class="mb-1"><?php echo e($user->name); ?></h4>
                <p class="mb-3"><?php echo e($user->email); ?></p>
                <div class="row">
                    <div class="col-12 mb-2">
                        <small>EMPLOYEE ID</small>
                        <h6 class="font-weight-bold"><?php echo e($employee->employee_id ?? 'N/A'); ?></h6>
                    </div>
                    <div class="col-6">
                        <small>DEPARTMENT</small>
                        <h6 class="font-weight-bold"><?php echo e($employee->department->name ?? 'N/A'); ?></h6>
                    </div>
                    <div class="col-6">
                        <small>DESIGNATION</small>
                        <h6 class="font-weight-bold"><?php echo e($employee->designation->name ?? 'N/A'); ?></h6>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    
    <div class="col-lg-6 col-12">
        <div class="card card-primary card-outline">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-calendar-check"></i> My Attendance (This Month)
                </h3>
                <div class="card-tools">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('mark own attendance')): ?>
                    <a href="<?php echo e(route('admin.hr.attendance.mark')); ?>" class="btn btn-tool btn-sm" title="Mark Attendance">
                        <i class="fas fa-user-check"></i>
                    </a>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view own attendance')): ?>
                    <a href="<?php echo e(route('admin.hr.attendance.index')); ?>" class="btn btn-tool btn-sm" title="View All Attendance">
                        <i class="fas fa-arrow-right"></i>
                    </a>
                    <?php endif; ?>
                </div>
            </div>
            <div class="card-body">
                <?php if($attendanceStats): ?>
                    <div class="row">
                        <div class="col-md-6 col-12 mb-2">
                            <div class="info-box bg-success">
                                <span class="info-box-icon"><i class="fas fa-check-circle"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Days Present</span>
                                    <span class="info-box-number"><?php echo e($attendanceStats['days_present']); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-12 mb-2">
                            <div class="info-box bg-warning">
                                <span class="info-box-icon"><i class="fas fa-calendar-times"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Days On Leave</span>
                                    <span class="info-box-number"><?php echo e($attendanceStats['days_on_leave']); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-12 mb-2">
                            <div class="info-box <?php echo e($attendanceStats['total_ot'] >= 0 ? 'bg-info' : 'bg-danger'); ?>">
                                <span class="info-box-icon"><i class="fas fa-clock"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Total OT</span>
                                    <span class="info-box-number">
                                        <?php echo e($attendanceStats['total_ot'] >= 0 ? '+' : ''); ?><?php echo e(number_format($attendanceStats['total_ot'], 2)); ?> hrs
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-12 mb-2">
                            <div class="info-box bg-secondary">
                                <span class="info-box-icon"><i class="fas fa-hourglass-half"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Pending Approvals</span>
                                    <span class="info-box-number"><?php echo e($attendanceStats['pending_approvals']); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i> No employee record found for your account.
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    
    <div class="col-lg-6 col-12">
        <div class="card card-success card-outline">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-wallet"></i> My Petty Cash
                </h3>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view own petty cash')): ?>
                <div class="card-tools">
                    <a href="<?php echo e(route('admin.pettycash.my-ledger')); ?>" class="btn btn-tool btn-sm">
                        <i class="fas fa-arrow-right"></i>
                    </a>
                </div>
                <?php endif; ?>
            </div>
            <div class="card-body">
                <?php if($pettyCashStats): ?>
                    <div class="row mb-3">
                        <div class="col-12">
                            <h4 class="text-center">
                                <strong><?php echo e($pettyCashStats['account_name']); ?></strong>
                            </h4>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 col-12 mb-2">
                            <div class="info-box bg-gradient-success">
                                <span class="info-box-icon"><i class="fas fa-coins"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Current Balance</span>
                                    <span class="info-box-number"><?php echo e(number_format($pettyCashStats['balance'], 2)); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-12 mb-2">
                            <div class="info-box bg-gradient-warning">
                                <span class="info-box-icon"><i class="fas fa-clock"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Pending Expenses</span>
                                    <span class="info-box-number"><?php echo e($pettyCashStats['pending_expenses']); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 mb-2">
                            <div class="info-box bg-gradient-info">
                                <span class="info-box-icon"><i class="fas fa-receipt"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Approved This Month</span>
                                    <span class="info-box-number"><?php echo e(number_format($pettyCashStats['approved_this_month'], 2)); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('add petty cash expense')): ?>
                    <div class="text-center">
                        <a href="<?php echo e(route('admin.pettycash.my-expense')); ?>" class="btn btn-success btn-block d-md-inline-block">
                            <i class="fas fa-plus"></i> Add New Expense
                        </a>
                    </div>
                    <?php endif; ?>
                <?php else: ?>
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i> No petty cash account assigned to you.
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>


<div class="row">
    <div class="col-md-12">
        <div class="card card-outline card-info">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="fas fa-bolt"></i> Quick Actions
                </h3>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('mark own attendance')): ?>
                    <div class="col-lg-3 col-6">
                        <a href="<?php echo e(route('admin.hr.attendance.mark')); ?>" class="btn btn-app btn-block bg-danger">
                            <i class="fas fa-user-check"></i> Mark Attendance
                        </a>
                    </div>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view own attendance')): ?>
                    <div class="col-lg-3 col-6">
                        <a href="<?php echo e(route('admin.hr.attendance.index')); ?>" class="btn btn-app btn-block bg-primary">
                            <i class="fas fa-calendar-check"></i> My Attendance
                        </a>
                    </div>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view own petty cash')): ?>
                    <div class="col-lg-3 col-6">
                        <a href="<?php echo e(route('admin.pettycash.my-ledger')); ?>" class="btn btn-app btn-block bg-success">
                            <i class="fas fa-wallet"></i> My Petty Cash
                        </a>
                    </div>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('add petty cash expense')): ?>
                    <div class="col-lg-3 col-6">
                        <a href="<?php echo e(route('admin.pettycash.my-expense')); ?>" class="btn btn-app btn-block bg-warning">
                            <i class="fas fa-receipt"></i> Add Expense
                        </a>
                    </div>
                    <?php endif; ?>

                    <div class="col-lg-3 col-6">
                        <a href="#" class="btn btn-app btn-block bg-info">
                            <i class="fas fa-user-circle"></i> My Profile
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laravel\rms\resources\views/user/dashboard.blade.php ENDPATH**/ ?>