<?php $__env->startSection('title', 'View Expense Details'); ?>

<?php $__env->startSection('content_header'); ?>
<h1>Expense Details</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Expense Information</h3>
            </div>
            <div class="card-body">
                <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                </div>
                <?php endif; ?>

                <?php if($errors->any()): ?>
                <div class="alert alert-danger alert-dismissible fade show">
                    <ul class="mb-0">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                </div>
                <?php endif; ?>

                <form method="POST" action="<?php echo e(route('admin.pettycash.approvals.update', $expense->id)); ?>" id="editExpenseForm">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <table class="table table-bordered">
                        <tr>
                            <th width="30%">Employee</th>
                            <td><?php echo e($expense->user->name); ?></td>
                        </tr>
                        <tr>
                            <th>Expense Date</th>
                            <td><?php echo e(\Carbon\Carbon::parse($expense->expense_date)->format('d-m-Y')); ?></td>
                        </tr>
                        <tr>
                            <th>Expense Type</th>
                            <td>
                                <?php if($expense->status === 'pending'): ?>
                                <select name="expense_account_id" class="form-control" required>
                                    <?php $__currentLoopData = $expenseAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($account->id); ?>"
                                        <?php echo e($expense->expense_account_id == $account->id ? 'selected' : ''); ?>>
                                        <?php echo e($account->code); ?> - <?php echo e($account->name); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php else: ?>
                                <?php echo e($expense->expenseAccount->code); ?> - <?php echo e($expense->expenseAccount->name); ?>

                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <th>Petty Cash Account</th>
                            <td><?php echo e($expense->pettyCashAccount->name); ?></td>
                        </tr>
                        <tr>
                            <th>Amount</th>
                            <td><strong class="text-primary"><?php echo e(number_format($expense->amount, 2)); ?></strong></td>
                        </tr>
                        <?php if($expense->is_vat_inclusive && $expense->vat_amount > 0): ?>
                        <tr>
                            <th>VAT Details</th>
                            <td>
                                <div class="card bg-light mb-0">
                                    <div class="card-body p-2">
                                        <table class="table table-sm mb-0">
                                            <tr>
                                                <td><strong>Amount Excluding VAT:</strong></td>
                                                <td class="text-right"><?php echo e(number_format($expense->amount_excluding_vat, 2)); ?></td>
                                            </tr>
                                            <tr>
                                                <td><strong>VAT (5%):</strong></td>
                                                <td class="text-right"><?php echo e(number_format($expense->vat_amount, 2)); ?></td>
                                            </tr>
                                            <tr class="font-weight-bold">
                                                <td>Total:</td>
                                                <td class="text-right"><?php echo e(number_format($expense->amount, 2)); ?></td>
                                            </tr>
                                            <?php if($expense->vat_claimable !== null): ?>
                                            <tr>
                                                <td><strong>VAT Claimable:</strong></td>
                                                <td class="text-right">
                                                    <?php if($expense->vat_claimable): ?>
                                                    <span class="badge badge-success">Yes</span>
                                                    <?php else: ?>
                                                    <span class="badge badge-secondary">No</span>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                            <?php endif; ?>
                                        </table>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <?php endif; ?>
                        <tr>
                            <th>Description</th>
                            <td>
                                <?php if($expense->status === 'pending'): ?>
                                <textarea name="description"
                                    class="form-control"
                                    rows="2"
                                    required><?php echo e($expense->description); ?></textarea>
                                <?php else: ?>
                                <?php echo e($expense->description); ?>

                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <th>Status</th>
                            <td>
                                <?php if($expense->status === 'pending'): ?>
                                <span class="badge badge-warning">Pending</span>
                                <?php elseif($expense->status === 'approved'): ?>
                                <span class="badge badge-success">Approved</span>
                                <?php else: ?>
                                <span class="badge badge-danger">Rejected</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <th>Submitted At</th>
                            <td><?php echo e($expense->created_at->format('d-m-Y H:i')); ?></td>
                        </tr>
                        <?php if($expense->status === 'approved' || $expense->status === 'rejected'): ?>
                        <tr>
                            <th><?php echo e($expense->status === 'approved' ? 'Approved' : 'Rejected'); ?> By</th>
                            <td>
                                <?php if($expense->approvedBy): ?>
                                <?php echo e($expense->approvedBy->name); ?>

                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <th><?php echo e($expense->status === 'approved' ? 'Approved' : 'Rejected'); ?> At</th>
                            <td>
                                <?php if($expense->approved_at): ?>
                                <?php echo e(\Carbon\Carbon::parse($expense->approved_at)->format('d-m-Y H:i')); ?>

                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endif; ?>
                        <?php if($expense->status === 'rejected' && $expense->rejection_reason): ?>
                        <tr>
                            <th>Rejection Reason</th>
                            <td class="text-danger"><?php echo e($expense->rejection_reason); ?></td>
                        </tr>
                        <?php endif; ?>
                    </table>

                    <?php if($expense->status === 'pending'): ?>
                    <div class="mt-3">
                        <button type="submit" class="btn btn-primary" form="editExpenseForm">
                            <i class="fas fa-save"></i> Save Changes
                        </button>
                    </div>
                    <?php endif; ?>
                </form>

                <?php if($expense->status === 'pending'): ?>
                <div class="mt-3">
                    <?php if($expense->is_vat_inclusive && $expense->vat_amount > 0): ?>
                    <div class="card bg-light mb-3">
                        <div class="card-body">
                            <h6 class="card-title mb-3"></h6>
                            <div class="form-group mb-0">
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox"
                                        class="custom-control-input"
                                        id="vat_claimable"
                                        name="vat_claimable"
                                        value="1">
                                    <label class="custom-control-label font-weight-bold" for="vat_claimable">
                                        VAT is Claimable
                                    </label>
                                </div>

                            </div>
                        </div>
                    </div>
                    <?php endif; ?>

                    <form method="POST"
                        action="<?php echo e(route('admin.pettycash.approvals.approve', $expense->id)); ?>"
                        id="approveForm"
                        style="display:inline;">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="vat_claimable" id="vat_claimable_hidden" value="0">
                        <button class="btn btn-success"
                            onclick="return confirmApprovalDetail()">
                            <i class="fas fa-check"></i> Approve
                        </button>
                    </form>

                    <button class="btn btn-danger"
                        data-toggle="modal"
                        data-target="#rejectModal">
                        <i class="fas fa-times"></i> Reject
                    </button>

                    <!-- Reject Modal -->
                    <div class="modal fade" id="rejectModal">
                        <div class="modal-dialog">
                            <form method="POST"
                                action="<?php echo e(route('admin.pettycash.approvals.reject', $expense->id)); ?>">
                                <?php echo csrf_field(); ?>
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Reject Expense</h5>
                                        <button type="button" class="close" data-dismiss="modal">
                                            <span>&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body">
                                        <textarea name="reason"
                                            class="form-control"
                                            rows="3"
                                            placeholder="Reason for rejection"
                                            required></textarea>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                        <button type="submit" class="btn btn-danger">Reject</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Receipt/Invoice Images</h3>
            </div>
            <div class="card-body">
                <?php if($expense->receipt_images && count($expense->receipt_images) > 0): ?>
                <div class="text-center">
                    <p class="text-muted small mb-3"><?php echo e(count($expense->receipt_images)); ?> image(s) uploaded</p>
                    <?php $__currentLoopData = $expense->receipt_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="mb-3">
                        <a href="<?php echo e(asset('storage/' . $image)); ?>" target="_blank">
                            <img src="<?php echo e(asset('storage/' . $image)); ?>"
                                alt="Receipt <?php echo e($index + 1); ?>"
                                class="img-fluid img-thumbnail"
                                style="max-height: 300px; cursor: pointer;">
                        </a>
                        <p class="mt-1 text-muted small">Image <?php echo e($index + 1); ?> of <?php echo e(count($expense->receipt_images)); ?></p>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <p class="mt-2 text-muted small">Click images to view full size</p>
                </div>
                <?php else: ?>
                <div class="text-center text-muted">
                    <i class="fas fa-receipt fa-3x mb-3"></i>
                    <p>No receipts/invoices uploaded</p>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<div class="mt-3">
    <a href="<?php echo e(route('admin.pettycash.approvals.index')); ?>" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Back to Approvals
    </a>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
    function confirmApprovalDetail() {
        // Get the checkbox value
        const checkbox = document.getElementById('vat_claimable');
        const hiddenInput = document.getElementById('vat_claimable_hidden');

        // Update hidden input based on checkbox state
        if (checkbox && checkbox.checked) {
            hiddenInput.value = '1';
        } else if (checkbox) {
            hiddenInput.value = '0';
        }

        return confirm('Approve this expense?');
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laravel\rms\resources\views/admin/pettycash/show-expense.blade.php ENDPATH**/ ?>