<?php $__env->startSection('title', 'Edit User'); ?>

<?php $__env->startSection('content_header'); ?>
<h1>Edit User: <?php echo e($user->name); ?></h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="card">
    <div class="card-body">
        <form method="POST" action="<?php echo e(route('admin.users.update', $user->id)); ?>">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <div class="form-group">
                <label for="name">Name <span class="text-danger">*</span></label>
                <input type="text"
                       name="name"
                       id="name"
                       class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                       value="<?php echo e(old('name', $user->name)); ?>"
                       required>
                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="form-group">
                <label for="email">Email <span class="text-danger">*</span></label>
                <input type="email"
                       name="email"
                       id="email"
                       class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                       value="<?php echo e(old('email', $user->email)); ?>"
                       required>
                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="form-group">
                <label for="password">New Password</label>
                <input type="password"
                       name="password"
                       id="password"
                       class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                <small class="form-text text-muted">Leave blank to keep current password. Minimum 8 characters if changing.</small>
            </div>

            <div class="form-group">
                <label for="password_confirmation">Confirm New Password</label>
                <input type="password"
                       name="password_confirmation"
                       id="password_confirmation"
                       class="form-control">
            </div>

            <div class="form-group">
                <label>Roles</label>
                <div class="card">
                    <div class="card-body">
                        <?php $__empty_1 = true; $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox"
                                   class="custom-control-input"
                                   name="roles[]"
                                   value="<?php echo e($role->name); ?>"
                                   id="role_<?php echo e($role->id); ?>"
                                   <?php echo e(in_array($role->name, old('roles', $userRoles)) ? 'checked' : ''); ?>>
                            <label class="custom-control-label" for="role_<?php echo e($role->id); ?>">
                                <?php echo e(ucfirst($role->name)); ?>

                            </label>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <p class="text-muted">No roles available</p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <label>Direct Permissions (Optional)</label>
                <small class="form-text text-muted mb-2">Grant specific permissions to this user beyond their role permissions.</small>

                <?php
                    $groupedPermissions = $permissions->groupBy(function($permission) {
                        $parts = explode(' ', $permission->name);
                        return $parts[0] ?? 'other';
                    });
                ?>

                <?php $__currentLoopData = $groupedPermissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category => $perms): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="card card-outline card-secondary mb-2">
                        <div class="card-header">
                            <h5 class="card-title">
                                <input type="checkbox" class="select-all-perms" data-category="<?php echo e($category); ?>">
                                <strong><?php echo e(ucfirst($category)); ?> Permissions</strong>
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <?php $__currentLoopData = $perms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-md-4 col-sm-6">
                                        <div class="custom-control custom-checkbox">
                                            <input type="checkbox"
                                                   class="custom-control-input permission-checkbox-user perm-category-<?php echo e($category); ?>"
                                                   name="permissions[]"
                                                   value="<?php echo e($permission->name); ?>"
                                                   id="permission_<?php echo e($permission->id); ?>"
                                                   <?php echo e(in_array($permission->name, old('permissions', $userPermissions)) ? 'checked' : ''); ?>>
                                            <label class="custom-control-label" for="permission_<?php echo e($permission->id); ?>">
                                                <?php echo e($permission->name); ?>

                                            </label>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <div class="form-group">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Update User
                </button>
                <a href="<?php echo e(route('admin.users.index')); ?>" class="btn btn-secondary">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
    // Select all permissions in a category
    document.querySelectorAll('.select-all-perms').forEach(checkbox => {
        checkbox.addEventListener('change', function() {
            const category = this.dataset.category;
            const categoryCheckboxes = document.querySelectorAll('.perm-category-' + category);
            categoryCheckboxes.forEach(cb => {
                cb.checked = this.checked;
            });
        });
    });

    // Update "select all" checkbox state when individual checkboxes change
    document.querySelectorAll('.permission-checkbox-user').forEach(checkbox => {
        checkbox.addEventListener('change', function() {
            const category = this.classList[2].replace('perm-category-', '');
            const allCategoryCheckboxes = document.querySelectorAll('.perm-category-' + category);
            const checkedCategoryCheckboxes = document.querySelectorAll('.perm-category-' + category + ':checked');
            const selectAllCheckbox = document.querySelector('.select-all-perms[data-category="' + category + '"]');

            if (selectAllCheckbox) {
                selectAllCheckbox.checked = allCategoryCheckboxes.length === checkedCategoryCheckboxes.length;
            }
        });
    });

    // Initialize "select all" checkbox states on page load
    document.addEventListener('DOMContentLoaded', function() {
        document.querySelectorAll('.select-all-perms').forEach(selectAllCheckbox => {
            const category = selectAllCheckbox.dataset.category;
            const allCategoryCheckboxes = document.querySelectorAll('.perm-category-' + category);
            const checkedCategoryCheckboxes = document.querySelectorAll('.perm-category-' + category + ':checked');

            if (allCategoryCheckboxes.length === checkedCategoryCheckboxes.length && allCategoryCheckboxes.length > 0) {
                selectAllCheckbox.checked = true;
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laravel\rms\resources\views/admin/users/edit.blade.php ENDPATH**/ ?>