

<?php $__env->startSection('title', 'Petty Cash Approvals'); ?>

<?php $__env->startSection('content_header'); ?>
<h1>Petty Cash Approvals</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="card">
    <div class="card-body p-0">

        <?php if($expenses->isEmpty()): ?>
            <div class="p-3 text-center text-muted">
                No pending petty cash expenses 🎉
            </div>
        <?php else: ?>

        <table class="table table-striped table-hover">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Employee</th>
                    <th>Expense</th>
                    <th>Description</th>
                    <th class="text-right">Amount</th>
                    <th class="text-right">VAT</th>
                    <th class="text-center">VAT Claimable</th>
                    <th class="text-center">Action</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e(\Carbon\Carbon::parse($expense->expense_date)->format('d-m-Y')); ?></td>
                    <td><?php echo e($expense->user->name); ?></td>
                    <td><?php echo e($expense->expenseAccount->code); ?> - <?php echo e($expense->expenseAccount->name); ?></td>
                    <td><?php echo e($expense->description); ?></td>
                    <td class="text-right"><?php echo e(number_format($expense->amount, 2)); ?></td>
                    <td class="text-right">
                        <?php if($expense->is_vat_inclusive && $expense->vat_amount > 0): ?>
                            <span class="badge badge-info" title="VAT Inclusive"><?php echo e(number_format($expense->vat_amount, 2)); ?></span>
                        <?php else: ?>
                            <span class="text-muted">—</span>
                        <?php endif; ?>
                    </td>
                    <td class="text-center">
                        <?php if($expense->is_vat_inclusive && $expense->vat_amount > 0): ?>
                            <input type="checkbox"
                                   class="vat-claimable-checkbox"
                                   id="vat_claimable_<?php echo e($expense->id); ?>"
                                   data-expense-id="<?php echo e($expense->id); ?>"
                                   title="Check if VAT is claimable">
                        <?php else: ?>
                            <span class="text-muted">—</span>
                        <?php endif; ?>
                    </td>
                    <td class="text-center">

                        <a href="<?php echo e(route('admin.pettycash.approvals.show', $expense->id)); ?>"
                           class="btn btn-sm btn-info"
                           title="View Details">
                            <i class="fas fa-eye"></i>
                        </a>

                        <form method="POST"
                              action="<?php echo e(route('admin.pettycash.approvals.approve', $expense->id)); ?>"
                              class="approve-form-<?php echo e($expense->id); ?>"
                              style="display:inline;">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="vat_claimable" id="vat_claimable_hidden_<?php echo e($expense->id); ?>" value="0">
                            <button class="btn btn-sm btn-success"
                                    onclick="return confirmApprove(<?php echo e($expense->id); ?>)"
                                    title="Approve">
                                <i class="fas fa-check"></i>
                            </button>
                        </form>

                        <button class="btn btn-sm btn-danger"
                                data-toggle="modal"
                                data-target="#rejectModal<?php echo e($expense->id); ?>"
                                title="Reject">
                            <i class="fas fa-times"></i>
                        </button>

                        <!-- Reject Modal -->
                        <div class="modal fade" id="rejectModal<?php echo e($expense->id); ?>">
                            <div class="modal-dialog">
                                <form method="POST"
                                      action="<?php echo e(route('admin.pettycash.approvals.reject', $expense->id)); ?>">
                                    <?php echo csrf_field(); ?>
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title">Reject Expense</h5>
                                        </div>
                                        <div class="modal-body">
                                            <textarea name="reason"
                                                      class="form-control"
                                                      placeholder="Reason for rejection"
                                                      required></textarea>
                                        </div>
                                        <div class="modal-footer">
                                            <button class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                            <button class="btn btn-danger">Reject</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>

                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        <?php endif; ?>

    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
function confirmApprove(expenseId) {
    // Get the checkbox value
    const checkbox = document.getElementById('vat_claimable_' + expenseId);
    const hiddenInput = document.getElementById('vat_claimable_hidden_' + expenseId);

    // Update hidden input based on checkbox state
    if (checkbox && checkbox.checked) {
        hiddenInput.value = '1';
    } else if (checkbox) {
        hiddenInput.value = '0';
    }

    return confirm('Approve this expense?');
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laravel\rms\resources\views/admin/pettycash/approvals.blade.php ENDPATH**/ ?>