<?php $__env->startSection('title', 'Attendance Records'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1>Attendance Records</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">All Attendance Records</h3>
        </div>
        <div class="card-body">
            <form method="GET" action="<?php echo e(route('admin.hr.attendance.index')); ?>" class="mb-3">
                <div class="row">
                    <div class="col-md-3">
                        <select name="month" class="form-control" onchange="this.form.submit()">
                            <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $monthValue => $monthLabel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($monthValue); ?>" <?php echo e(request('month', now()->format('Y-m')) == $monthValue ? 'selected' : ''); ?>>
                                    <?php echo e($monthLabel); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
            </form>

            <div class="row mb-3">
                <div class="col-md-4">
                    <div class="info-box">
                        <span class="info-box-icon bg-info"><i class="fas fa-calendar-check"></i></span>
                        <div class="info-box-content">
                            <span class="info-box-text">Days Worked</span>
                            <span class="info-box-number"><?php echo e($summary['days_worked']); ?></span>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="info-box">
                        <span class="info-box-icon bg-warning"><i class="fas fa-calendar-times"></i></span>
                        <div class="info-box-content">
                            <span class="info-box-text">Off Days</span>
                            <span class="info-box-number"><?php echo e($summary['off_days']); ?></span>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="info-box">
                        <span class="info-box-icon <?php echo e($summary['total_ot'] >= 0 ? 'bg-success' : 'bg-danger'); ?>">
                            <i class="fas fa-clock"></i>
                        </span>
                        <div class="info-box-content">
                            <span class="info-box-text">Total OT</span>
                            <span class="info-box-number">
                                <?php echo e($summary['total_ot'] >= 0 ? '+' : ''); ?><?php echo e(number_format($summary['total_ot'], 2)); ?> hrs
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Desktop View -->
            <div class="d-none d-md-block">
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Check In</th>
                            <th>Check Out</th>
                            <th>Total Hours</th>
                            <th>OT</th>
                            <th>Status</th>
                            <th>Approved By</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $attendances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attendance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($attendance->date->format('d M Y')); ?></td>
                                <td><?php echo e($attendance->check_in ? \Carbon\Carbon::parse($attendance->check_in)->format('h:i A') : 'N/A'); ?></td>
                                <td><?php echo e($attendance->check_out ? \Carbon\Carbon::parse($attendance->check_out)->format('h:i A') : 'N/A'); ?></td>
                                <td><?php echo e($attendance->total_hours ? number_format($attendance->total_hours, 2) . ' hrs' : 'N/A'); ?></td>
                                <td>
                                    <?php if($attendance->total_hours): ?>
                                        <?php
                                            $overtime = $attendance->total_hours - 9;
                                            $otClass = $overtime >= 0 ? 'text-success' : 'text-danger';
                                            $otSign = $overtime >= 0 ? '+' : '';
                                        ?>
                                        <span class="<?php echo e($otClass); ?> font-weight-bold">
                                            <?php echo e($otSign); ?><?php echo e(number_format($overtime, 2)); ?> hrs
                                        </span>
                                    <?php else: ?>
                                        <span class="text-muted">N/A</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php switch($attendance->status):
                                        case ('present'): ?>
                                            <span class="badge badge-success">Present</span>
                                            <?php break; ?>
                                        <?php case ('absent'): ?>
                                            <span class="badge badge-danger">Absent</span>
                                            <?php break; ?>
                                        <?php case ('late'): ?>
                                            <span class="badge badge-warning">Late</span>
                                            <?php break; ?>
                                        <?php case ('half_day'): ?>
                                            <span class="badge badge-info">Half Day</span>
                                            <?php break; ?>
                                        <?php case ('on_leave'): ?>
                                            <span class="badge badge-secondary">On Leave</span>
                                            <?php break; ?>
                                    <?php endswitch; ?>
                                </td>
                                <td>
                                    <?php if($attendance->approved_by): ?>
                                        <span class="badge badge-success">
                                            <i class="fas fa-check"></i> <?php echo e($attendance->approver->name); ?>

                                        </span>
                                    <?php else: ?>
                                        <span class="badge badge-warning">Pending</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="text-center">No attendance records found.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <!-- Mobile View -->
            <div class="d-md-none">
                <?php $__empty_1 = true; $__currentLoopData = $attendances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attendance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="card mb-3">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-start mb-2">
                                <h5 class="mb-0"><?php echo e($attendance->date->format('d M Y')); ?></h5>
                                <?php if($attendance->approved_by): ?>
                                    <span class="badge badge-success">
                                        <i class="fas fa-check"></i> Approved
                                    </span>
                                <?php else: ?>
                                    <span class="badge badge-warning">Pending</span>
                                <?php endif; ?>
                            </div>

                            <div class="row mb-2">
                                <div class="col-6">
                                    <small class="text-muted">Check In</small>
                                    <div class="font-weight-bold">
                                        <?php echo e($attendance->check_in ? \Carbon\Carbon::parse($attendance->check_in)->format('h:i A') : 'N/A'); ?>

                                    </div>
                                </div>
                                <div class="col-6">
                                    <small class="text-muted">Check Out</small>
                                    <div class="font-weight-bold">
                                        <?php echo e($attendance->check_out ? \Carbon\Carbon::parse($attendance->check_out)->format('h:i A') : 'N/A'); ?>

                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-6">
                                    <small class="text-muted">Total Hours</small>
                                    <div class="font-weight-bold">
                                        <?php echo e($attendance->total_hours ? number_format($attendance->total_hours, 2) . ' hrs' : 'N/A'); ?>

                                    </div>
                                </div>
                                <div class="col-6">
                                    <small class="text-muted">OT</small>
                                    <div>
                                        <?php if($attendance->total_hours): ?>
                                            <?php
                                                $overtime = $attendance->total_hours - 9;
                                                $otClass = $overtime >= 0 ? 'text-success' : 'text-danger';
                                                $otSign = $overtime >= 0 ? '+' : '';
                                            ?>
                                            <span class="<?php echo e($otClass); ?> font-weight-bold">
                                                <?php echo e($otSign); ?><?php echo e(number_format($overtime, 2)); ?> hrs
                                            </span>
                                        <?php else: ?>
                                            <span class="text-muted">N/A</span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i> No attendance records found.
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="card-footer">
            <?php echo e($attendances->links()); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laravel\rms\resources\views/admin/hr/attendance/index.blade.php ENDPATH**/ ?>