@extends('adminlte::page')

@section('content')
<div class="container">
    <h2>{{ isset($vendor) ? 'Edit' : 'Create' }} Vendor</h2>
    <form method="POST" action="{{ isset($vendor) ? route('vendors.update', $vendor) : route('vendors.store') }}">
        @csrf
        @if(isset($vendor)) @method('PUT') @endif

        <div class="mb-3">
            <label>Company Name</label>
            <input name="company_name" class="form-control" required value="{{ old('company_name', $vendor->company_name ?? '') }}">
        </div>
        <div class="mb-3">
            <label>Address</label>
            <textarea name="address" class="form-control">{{ old('address', $vendor->address ?? '') }}</textarea>
        </div>
        <div class="mb-3">
            <label>TRN</label>
            <input name="trn" class="form-control" value="{{ old('trn', $vendor->trn ?? '') }}">
        </div>
        <div class="mb-3">
            <label>Phone</label>
            <input name="phone" class="form-control" value="{{ old('phone', $vendor->phone ?? '') }}">
        </div>
        <div class="mb-3">
            <label>Email</label>
            <input name="email" class="form-control" value="{{ old('email', $vendor->email ?? '') }}">
        </div>
        <div class="mb-3">
            <label>Website</label>
            <input name="website" class="form-control" value="{{ old('website', $vendor->website ?? '') }}">
        </div>
        <div class="mb-3">
            <label>Category</label>
            <select name="category" class="form-control">
                @foreach(['hardware store', 'generator parts', 'filters', 'machine parts', 'general'] as $cat)
                    <option value="{{ $cat }}" @selected(old('category', $vendor->category ?? '') == $cat)>{{ ucfirst($cat) }}</option>
                @endforeach
            </select>
        </div>
        <div class="mb-3">
            <label>Remarks</label>
            <textarea name="remarks" class="form-control">{{ old('remarks', $vendor->remarks ?? '') }}</textarea>
        </div>

        <hr>
        <h5>Vendor Contacts</h5>
        <div id="contacts-wrapper">
            @php $contacts = old('contacts', $vendor->contacts ?? [null]) @endphp
            @foreach($contacts as $i => $contact)
                <div class="border p-2 mb-2 contact-block">
                    <div class="row">
                        <div class="col"><input class="form-control" name="contacts[{{ $i }}][name]" placeholder="Name" value="{{ $contact->name ?? '' }}"></div>
                        <div class="col"><input class="form-control" name="contacts[{{ $i }}][designation]" placeholder="Designation" value="{{ $contact->designation ?? '' }}"></div>
                        <div class="col"><input class="form-control" name="contacts[{{ $i }}][email]" placeholder="Email" value="{{ $contact->email ?? '' }}"></div>
                    </div>
                    <div class="row mt-2">
                        <div class="col"><input class="form-control" name="contacts[{{ $i }}][mobile1]" placeholder="Mobile 1" value="{{ $contact->mobile1 ?? '' }}"></div>
                        <div class="col"><input class="form-control" name="contacts[{{ $i }}][mobile2]" placeholder="Mobile 2" value="{{ $contact->mobile2 ?? '' }}"></div>
                        <div class="col"><input class="form-control" name="contacts[{{ $i }}][mobile3]" placeholder="Mobile 3" value="{{ $contact->mobile3 ?? '' }}"></div>
                    </div>
                    <div class="mt-2">
                        <input class="form-control" name="contacts[{{ $i }}][phone]" placeholder="Phone" value="{{ $contact->phone ?? '' }}">
                        <textarea class="form-control mt-2" name="contacts[{{ $i }}][remarks]" placeholder="Remarks">{{ $contact->remarks ?? '' }}</textarea>
                    </div>
                </div>
            @endforeach
        </div>
        <button type="button" class="btn btn-sm btn-secondary" onclick="addContact()">+ Add Contact</button>

        <hr>
        <button type="submit" class="btn btn-success">Save Vendor</button>
    </form>
</div>

@push('scripts')
<script>
    let contactIndex = {{ count($contacts) }};
    function addContact() {
        const wrapper = document.getElementById('contacts-wrapper');
        const html = `
            <div class="border p-2 mb-2 contact-block">
                <div class="row">
                    <div class="col"><input class="form-control" name="contacts[${contactIndex}][name]" placeholder="Name"></div>
                    <div class="col"><input class="form-control" name="contacts[${contactIndex}][designation]" placeholder="Designation"></div>
                    <div class="col"><input class="form-control" name="contacts[${contactIndex}][email]" placeholder="Email"></div>
                </div>
                <div class="row mt-2">
                    <div class="col"><input class="form-control" name="contacts[${contactIndex}][mobile1]" placeholder="Mobile 1"></div>
                    <div class="col"><input class="form-control" name="contacts[${contactIndex}][mobile2]" placeholder="Mobile 2"></div>
                    <div class="col"><input class="form-control" name="contacts[${contactIndex}][mobile3]" placeholder="Mobile 3"></div>
                </div>
                <div class="mt-2">
                    <input class="form-control" name="contacts[${contactIndex}][phone]" placeholder="Phone">
                    <textarea class="form-control mt-2" name="contacts[${contactIndex}][remarks]" placeholder="Remarks"></textarea>
                </div>
            </div>
        `;
        wrapper.insertAdjacentHTML('beforeend', html);
        contactIndex++;
    }
</script>
@endpush
@endsection
