@extends('adminlte::page')

@section('title', 'User Details')

@section('content_header')
<h1>User Details</h1>
@stop

@section('content')

<div class="card">
    <div class="card-header">
        <h3 class="card-title">{{ $user->name }}</h3>
        <div class="card-tools">
            <a href="{{ route('admin.users.edit', $user->id) }}" class="btn btn-sm btn-warning">
                <i class="fas fa-edit"></i> Edit
            </a>
        </div>
    </div>
    <div class="card-body">
        <table class="table table-bordered">
            <tr>
                <th width="30%">Name</th>
                <td>{{ $user->name }}</td>
            </tr>
            <tr>
                <th>Email</th>
                <td>{{ $user->email }}</td>
            </tr>
            <tr>
                <th>Created At</th>
                <td>{{ $user->created_at->format('d-m-Y H:i') }}</td>
            </tr>
            <tr>
                <th>Last Updated</th>
                <td>{{ $user->updated_at->format('d-m-Y H:i') }}</td>
            </tr>
        </table>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Assigned Roles</h3>
            </div>
            <div class="card-body">
                @forelse($user->roles as $role)
                    <span class="badge badge-info badge-lg mr-1 mb-1">{{ $role->name }}</span>
                @empty
                    <p class="text-muted">No roles assigned</p>
                @endforelse
            </div>
        </div>
    </div>

    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Direct Permissions</h3>
            </div>
            <div class="card-body" style="max-height: 300px; overflow-y: auto;">
                @forelse($user->permissions as $permission)
                    <span class="badge badge-success badge-sm mr-1 mb-1">{{ $permission->name }}</span>
                @empty
                    <p class="text-muted">No direct permissions assigned</p>
                @endforelse
            </div>
        </div>
    </div>
</div>

<div class="mt-3">
    <a href="{{ route('admin.users.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Back to Users
    </a>
</div>

@stop
