@extends('adminlte::page')

@section('title', 'Role Details')

@section('content_header')
    <h1>Role: {{ ucfirst($role->name) }}</h1>
@stop

@section('content')
    <div class="row">
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Role Information</h3>
                </div>
                <div class="card-body">
                    <table class="table table-sm">
                        <tr>
                            <th>Name:</th>
                            <td>{{ ucfirst($role->name) }}</td>
                        </tr>
                        <tr>
                            <th>Permissions:</th>
                            <td><span class="badge badge-info">{{ $role->permissions->count() }}</span></td>
                        </tr>
                        <tr>
                            <th>Users:</th>
                            <td><span class="badge badge-secondary">{{ $role->users->count() }}</span></td>
                        </tr>
                        <tr>
                            <th>Created:</th>
                            <td>{{ $role->created_at->format('d M Y') }}</td>
                        </tr>
                    </table>

                    <div class="mt-3">
                        <a href="{{ route('admin.roles.edit', $role) }}" class="btn btn-primary btn-block">
                            <i class="fas fa-edit"></i> Edit Role
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Assigned Permissions</h3>
                </div>
                <div class="card-body">
                    @if($role->permissions->count() > 0)
                        @php
                            $groupedPerms = $role->permissions->groupBy(function($perm) {
                                $parts = explode(' ', $perm->name);
                                return $parts[0] ?? 'other';
                            });
                        @endphp

                        @foreach($groupedPerms as $category => $perms)
                            <h5 class="mt-3">{{ ucfirst($category) }}</h5>
                            <div class="row">
                                @foreach($perms as $permission)
                                    <div class="col-md-4 col-sm-6 mb-2">
                                        <span class="badge badge-success">
                                            <i class="fas fa-check"></i> {{ $permission->name }}
                                        </span>
                                    </div>
                                @endforeach
                            </div>
                        @endforeach
                    @else
                        <p class="text-muted">No permissions assigned to this role.</p>
                    @endif
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Users with this Role</h3>
                </div>
                <div class="card-body">
                    @if($role->users->count() > 0)
                        <table class="table table-bordered table-sm">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($role->users as $user)
                                    <tr>
                                        <td>{{ $user->name }}</td>
                                        <td>{{ $user->email }}</td>
                                        <td>
                                            <a href="{{ route('admin.users.edit', $user) }}" class="btn btn-sm btn-info">
                                                <i class="fas fa-edit"></i> Edit User
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    @else
                        <p class="text-muted">No users assigned to this role.</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
@stop
