@extends('adminlte::page')

@section('title', 'Top Up Petty Cash')

@section('content_header')
<h1>Top Up – {{ $account->name }}</h1>
@stop

@section('content')

<form method="POST"
      action="{{ route('admin.pettycash.topup.store', $account->id) }}">
    @csrf

    <div class="card">
        <div class="card-body">

            <div class="form-group">
                <label>Source Account</label>
                <select name="source_account_id"
                        id="source_account"
                        class="form-control"
                        required>
                    <option value="">-- Select Account --</option>
                    @foreach($sourceAccounts as $src)
                        <option value="{{ $src->id }}"
                                data-balance="{{ $src->balance }}">
                            {{ $src->code }} – {{ $src->name }}
                        </option>
                    @endforeach
                </select>

                <small id="availableBalance"
                       class="form-text text-muted"
                       style="display:none;">
                    Available Balance: <strong id="balanceValue"></strong>
                </small>
            </div>

            <div class="form-group">
                <label>Amount</label>
                <input type="number"
                       step="0.01"
                       name="amount"
                       id="amount"
                       class="form-control"
                       required>
            </div>

            <div class="form-group">
                <label>Date</label>
                <input type="date"
                       name="date"
                       class="form-control"
                       value="{{ date('Y-m-d') }}"
                       required>
            </div>

            <div class="form-group">
                <label>Description</label>
                <textarea name="description"
                          class="form-control"
                          rows="2"></textarea>
            </div>

        </div>

        <div class="card-footer text-right">
            <a href="{{ route('admin.pettycash.index') }}"
               class="btn btn-secondary">Cancel</a>

            <button class="btn btn-success">
                Top Up Petty Cash
            </button>
        </div>
    </div>
</form>


@push('js')
<script>
    let availableBalance = 0;

    document.getElementById('source_account')
        .addEventListener('change', function () {

        const selected = this.options[this.selectedIndex];
        availableBalance = parseFloat(
            selected.getAttribute('data-balance') || 0
        );

        if (this.value) {
            document.getElementById('availableBalance').style.display = 'block';
            document.getElementById('balanceValue').innerText =
                availableBalance.toFixed(2);
        } else {
            document.getElementById('availableBalance').style.display = 'none';
        }

        document.getElementById('amount').value = '';
        document.getElementById('amount').max = availableBalance;
    });

    document.getElementById('amount')
        .addEventListener('input', function () {

        if (parseFloat(this.value) > availableBalance) {
            alert('Top-up amount cannot exceed available balance');
            this.value = availableBalance;
        }
    });
</script>
@endpush

@stop
