@extends('adminlte::page')

@section('title', 'Petty Cash Ledger')

@section('content_header')
<h1>{{ $account->name }}</h1>
@stop

@section('content')

<a href="{{ route('admin.pettycash.index') }}" class="btn btn-secondary mb-3">
    ← Back to Petty Cash Overview
</a>

<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            Employee: {{ $account->user->name ?? 'N/A' }}
        </h3>
    </div>

    <div class="card-body p-0">
        <table class="table table-bordered table-sm">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Ref</th>
                    <th>Description</th>
                    <th class="text-right">Debit</th>
                    <th class="text-right">Credit</th>
                    <th class="text-right">Balance</th>
                </tr>
            </thead>
            <tbody>
            @php $balance = 0; @endphp

            @foreach($ledger as $line)
                @php
                    $balance += $line->debit;
                    $balance -= $line->credit;
                @endphp
                <tr>
                    <td>{{ $line->journalEntry->date }}</td>
                    <td>{{ $line->journalEntry->reference }}</td>
                    <td>{{ $line->journalEntry->description }}</td>
                    <td class="text-right">{{ number_format($line->debit, 2) }}</td>
                    <td class="text-right">{{ number_format($line->credit, 2) }}</td>
                    <td class="text-right font-weight-bold">
                        {{ number_format($balance, 2) }}
                    </td>
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>
</div>

@stop
