@extends('adminlte::page')

@section('title', 'My Petty Cash')

@section('content_header')
<h1>My Petty Cash Ledger</h1>
@stop

@section('content')

@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show">
        {{ session('success') }}
        <button type="button" class="close" data-dismiss="alert">&times;</button>
    </div>
@endif

@if($errors->any())
    <div class="alert alert-danger alert-dismissible fade show">
        <ul class="mb-0">
            @foreach($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
        <button type="button" class="close" data-dismiss="alert">&times;</button>
    </div>
@endif

{{-- Pending Expenses Section --}}
@if($pendingExpenses->isNotEmpty())
<div class="card mb-3">
    <div class="card-header bg-warning">
        <h3 class="card-title">
            <i class="fas fa-clock"></i> Pending Approval
        </h3>
    </div>

    {{-- Desktop View --}}
    <div class="card-body p-0 d-none d-md-block">
        <table class="table table-striped table-hover mb-0">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Expense Type</th>
                    <th>Description</th>
                    <th class="text-right">Amount</th>
                    <th>Receipt</th>
                    <th class="text-center">Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach($pendingExpenses as $expense)
                <tr>
                    <td>{{ \Carbon\Carbon::parse($expense->expense_date)->format('d-m-Y') }}</td>
                    <td>{{ $expense->expenseAccount->code }} - {{ $expense->expenseAccount->name }}</td>
                    <td>{{ $expense->description }}</td>
                    <td class="text-right">{{ number_format($expense->amount, 2) }}</td>
                    <td>
                        @if($expense->receipt_images && count($expense->receipt_images) > 0)
                            <span class="text-success">
                                <i class="fas fa-image"></i> {{ count($expense->receipt_images) }} image(s)
                            </span>
                        @else
                            <span class="text-muted">
                                <i class="fas fa-times"></i> No receipts
                            </span>
                        @endif
                    </td>
                    <td class="text-center">
                        <a href="{{ route('admin.pettycash.my-expense.edit', $expense->id) }}"
                           class="btn btn-sm btn-primary"
                           title="Edit">
                            <i class="fas fa-edit"></i>
                        </a>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    {{-- Mobile View --}}
    <div class="card-body d-md-none">
        @foreach($pendingExpenses as $expense)
        <div class="card mb-2">
            <div class="card-body p-3">
                <div class="d-flex justify-content-between align-items-start mb-2">
                    <h6 class="mb-0">{{ \Carbon\Carbon::parse($expense->expense_date)->format('d M Y') }}</h6>
                    <span class="badge badge-warning">Pending</span>
                </div>

                <div class="mb-2">
                    <small class="text-muted">Expense Type</small>
                    <div class="font-weight-bold">{{ $expense->expenseAccount->code }} - {{ $expense->expenseAccount->name }}</div>
                </div>

                <div class="mb-2">
                    <small class="text-muted">Description</small>
                    <div>{{ $expense->description }}</div>
                </div>

                <div class="row mb-2">
                    <div class="col-6">
                        <small class="text-muted">Amount</small>
                        <div class="font-weight-bold text-danger">{{ number_format($expense->amount, 2) }}</div>
                    </div>
                    <div class="col-6">
                        <small class="text-muted">Receipt</small>
                        <div>
                            @if($expense->receipt_images && count($expense->receipt_images) > 0)
                                <span class="text-success">
                                    <i class="fas fa-image"></i> {{ count($expense->receipt_images) }}
                                </span>
                            @else
                                <span class="text-muted">
                                    <i class="fas fa-times"></i> None
                                </span>
                            @endif
                        </div>
                    </div>
                </div>

                <a href="{{ route('admin.pettycash.my-expense.edit', $expense->id) }}"
                   class="btn btn-sm btn-primary btn-block">
                    <i class="fas fa-edit"></i> Edit Expense
                </a>
            </div>
        </div>
        @endforeach
    </div>
</div>
@endif

{{-- Ledger Section --}}
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <strong>{{ $account->name }}</strong>

        <div class="d-flex">

            {{-- Month Selector --}}
            <form method="GET" action="{{ route('admin.pettycash.my-ledger') }}" class="mr-2">
                <select name="month"
                        class="form-control"
                        onchange="this.form.submit()">
                    @foreach($months as $month)
                        <option value="{{ $month }}"
                            {{ $selectedMonth === $month ? 'selected' : '' }}>
                            {{ \Carbon\Carbon::createFromFormat('Y-m', $month)->format('F Y') }}
                        </option>
                    @endforeach
                </select>
            </form>

            {{-- Add Expense --}}
            @can('add petty cash expense')
            <a href="{{ route('admin.pettycash.my-expense') }}"
               class="btn btn-sm btn-danger">
                Add Expense
            </a>
            @endcan

        </div>
    </div>


    {{-- Desktop View --}}
    <div class="card-body p-0 d-none d-md-block">
        <table class="table table-striped table-hover">
            <thead>
            <tr>
                <th>Date</th>
                <th>Description</th>
                <th class="text-right">Debit</th>
                <th class="text-right">Credit</th>
                <th class="text-right">Balance</th>
                <th class="text-center">Action</th>
            </tr>
            </thead>
            <tbody>
            @php $balance = 0; @endphp

            @foreach($transactions as $tx)
                @php
                    $balance += ($tx->debit - $tx->credit);
                    // Find related petty cash expense (if it's a credit transaction)
                    $relatedExpense = null;
                    if ($tx->credit > 0) {
                        $key = $tx->journalEntry->date->format('Y-m-d') . '_' . $tx->credit;
                        $relatedExpense = $approvedExpenses->get($key);
                    }
                @endphp
                <tr>

                    <td>{{ $tx->journalEntry->date->format('d-m-Y') }}</td>
                    <td>{{ $tx->journalEntry->description }}</td>
                    <td class="text-right">{{ number_format($tx->debit, 2) }}</td>
                    <td class="text-right">{{ number_format($tx->credit, 2) }}</td>
                    <td class="text-right">
                        {{ number_format($balance, 2) }}
                    </td>
                    <td class="text-center">
                        @if($tx->credit > 0 && $relatedExpense)
                            <button type="button" class="btn btn-sm btn-info" data-toggle="modal" data-target="#viewModal{{ $tx->id }}">
                                <i class="fas fa-eye"></i>
                            </button>

                            {{-- View Modal --}}
                            <div class="modal fade" id="viewModal{{ $tx->id }}" tabindex="-1" role="dialog">
                                <div class="modal-dialog modal-lg" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title">Transaction Details</h5>
                                            <button type="button" class="close" data-dismiss="modal">
                                                <span>&times;</span>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            <div class="row mb-3">
                                                <div class="col-md-6">
                                                    <strong>Date:</strong> {{ $tx->journalEntry->date->format('d M Y') }}
                                                </div>
                                                <div class="col-md-6">
                                                    <strong>Amount:</strong> {{ number_format($tx->credit, 2) }}
                                                </div>
                                            </div>
                                            <div class="mb-3">
                                                <strong>Description:</strong><br>
                                                {{ $relatedExpense->description }}
                                            </div>
                                            <div class="mb-3">
                                                <strong>Expense Account:</strong><br>
                                                {{ $relatedExpense->expenseAccount->code }} - {{ $relatedExpense->expenseAccount->name }}
                                            </div>
                                            @if($relatedExpense->receipt_images && count($relatedExpense->receipt_images) > 0)
                                                <div class="mb-3">
                                                    <strong>Receipt Images:</strong><br>
                                                    <div class="row">
                                                        @foreach($relatedExpense->receipt_images as $image)
                                                            <div class="col-md-4 mb-3">
                                                                <a href="{{ asset('storage/' . $image) }}" target="_blank">
                                                                    <img src="{{ asset('storage/' . $image) }}"
                                                                         class="img-fluid img-thumbnail"
                                                                         alt="Receipt">
                                                                </a>
                                                            </div>
                                                        @endforeach
                                                    </div>
                                                </div>
                                            @else
                                                <div class="alert alert-info">
                                                    <i class="fas fa-info-circle"></i> No receipt images attached to this expense.
                                                </div>
                                            @endif
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @else
                            <span class="text-muted">—</span>
                        @endif
                    </td>
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>

    {{-- Mobile View --}}
    <div class="card-body d-md-none">
        @php $balance = 0; @endphp

        @forelse($transactions as $tx)
            @php
                $balance += ($tx->debit - $tx->credit);
                // Find related petty cash expense (if it's a credit transaction)
                $relatedExpense = null;
                if ($tx->credit > 0) {
                    $key = $tx->journalEntry->date->format('Y-m-d') . '_' . $tx->credit;
                    $relatedExpense = $approvedExpenses->get($key);
                }
            @endphp
            <div class="card mb-2">
                <div class="card-body p-3">
                    <div class="d-flex justify-content-between align-items-start mb-2">
                        <h6 class="mb-0">{{ $tx->journalEntry->date->format('d M Y') }}</h6>
                        @if($tx->debit > 0)
                            <span class="badge badge-success">Debit</span>
                        @else
                            <span class="badge badge-danger">Credit</span>
                        @endif
                    </div>

                    <div class="mb-2">
                        <small class="text-muted">Description</small>
                        <div>{{ $tx->journalEntry->description }}</div>
                    </div>

                    <div class="row mb-2">
                        <div class="col-4">
                            <small class="text-muted">Debit</small>
                            <div class="font-weight-bold {{ $tx->debit > 0 ? 'text-success' : 'text-muted' }}">
                                {{ number_format($tx->debit, 2) }}
                            </div>
                        </div>
                        <div class="col-4">
                            <small class="text-muted">Credit</small>
                            <div class="font-weight-bold {{ $tx->credit > 0 ? 'text-danger' : 'text-muted' }}">
                                {{ number_format($tx->credit, 2) }}
                            </div>
                        </div>
                        <div class="col-4">
                            <small class="text-muted">Balance</small>
                            <div class="font-weight-bold text-primary">
                                {{ number_format($balance, 2) }}
                            </div>
                        </div>
                    </div>

                    @if($tx->credit > 0 && $relatedExpense)
                        <button type="button" class="btn btn-sm btn-info btn-block" data-toggle="modal" data-target="#viewModalMobile{{ $tx->id }}">
                            <i class="fas fa-eye"></i> View Details
                        </button>

                        {{-- View Modal for Mobile --}}
                        <div class="modal fade" id="viewModalMobile{{ $tx->id }}" tabindex="-1" role="dialog">
                            <div class="modal-dialog modal-lg" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Transaction Details</h5>
                                        <button type="button" class="close" data-dismiss="modal">
                                            <span>&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body">
                                        <div class="mb-3">
                                            <strong>Date:</strong> {{ $tx->journalEntry->date->format('d M Y') }}
                                        </div>
                                        <div class="mb-3">
                                            <strong>Amount:</strong> {{ number_format($tx->credit, 2) }}
                                        </div>
                                        <div class="mb-3">
                                            <strong>Description:</strong><br>
                                            {{ $relatedExpense->description }}
                                        </div>
                                        <div class="mb-3">
                                            <strong>Expense Account:</strong><br>
                                            {{ $relatedExpense->expenseAccount->code }} - {{ $relatedExpense->expenseAccount->name }}
                                        </div>
                                        @if($relatedExpense->receipt_images && count($relatedExpense->receipt_images) > 0)
                                            <div class="mb-3">
                                                <strong>Receipt Images:</strong><br>
                                                <div class="row">
                                                    @foreach($relatedExpense->receipt_images as $image)
                                                        <div class="col-12 mb-3">
                                                            <a href="{{ asset('storage/' . $image) }}" target="_blank">
                                                                <img src="{{ asset('storage/' . $image) }}"
                                                                     class="img-fluid img-thumbnail"
                                                                     alt="Receipt">
                                                            </a>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            </div>
                                        @else
                                            <div class="alert alert-info">
                                                <i class="fas fa-info-circle"></i> No receipt images attached to this expense.
                                            </div>
                                        @endif
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        @empty
            <div class="text-center text-muted py-3">
                <i class="fas fa-inbox fa-2x mb-2"></i>
                <p>No transactions found for this month.</p>
            </div>
        @endforelse
    </div>

    <div class="card-footer text-right">
        <strong>Current Balance:
            {{ number_format($account->balance, 2) }}
        </strong>
    </div>
</div>

@stop
