@extends('adminlte::page')

@section('title', 'Petty Cash Overview')

@section('content_header')
<h1>Petty Cash Management</h1>
@stop

@section('content')

<div class="card">
    <div class="card-header">
        <h3 class="card-title">Individual Petty Cash Accounts</h3>
    </div>

    <div class="card-body p-0">
        <table class="table table-hover table-striped">
            <thead>
                <tr>
                    <th>Code</th>
                    <th>Account</th>
                    <th>Employee</th>
                    <th class="text-right">Balance</th>
                    <th class="text-right">Action</th>
                </tr>
            </thead>
            <tbody>
            @foreach($accounts as $account)
                <tr>
                    <td>{{ $account->code }}</td>
                    <td>{{ $account->name }}</td>
                    <td>{{ $account->user->name ?? '—' }}</td>
                    <td class="text-right">
                        {{ number_format($account->balance, 2) }}
                    </td>
                    <td class="text-right">
                        <a href="{{ route('admin.pettycash.show', $account->id) }}"
                           class="btn btn-sm btn-primary">
                            View Ledger
                        </a>

                    @can('topup petty cash')
                        <a href="{{ route('admin.pettycash.topup', $account->id) }}"
                           class="btn btn-sm btn-success">
                            Top Up
                        </a>
                    @endcan

                    </td>
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>
</div>

@stop
