@extends('adminlte::page')

@section('title', 'Petty Cash Expense Account Settings')

@section('content_header')
<h1>Petty Cash Expense Account Settings</h1>
@stop

@section('content')

<div class="card">
    <div class="card-header">
        <h3 class="card-title">Select Expense Accounts Visible in Petty Cash Forms</h3>
    </div>

    <form method="POST" action="{{ route('admin.pettycash.expense-account-settings.update') }}">
        @csrf
        @method('PUT')

        <div class="card-body">
            @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show">
                    <i class="fas fa-check-circle"></i> {{ session('success') }}
                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                </div>
            @endif

            <div class="alert alert-info">
                <i class="fas fa-info-circle"></i>
                <strong>Instructions:</strong> Check the boxes for expense accounts you want to be visible in the petty cash expense forms.
                Unchecked accounts will be hidden from users when they submit expenses.
            </div>

            <div class="form-group">
                <div class="custom-control custom-checkbox mb-2">
                    <input type="checkbox" class="custom-control-input" id="select_all">
                    <label class="custom-control-label font-weight-bold" for="select_all">
                        Select / Deselect All
                    </label>
                </div>
            </div>

            <hr>

            <div class="row">
                @foreach($expenseAccounts as $account)
                    <div class="col-md-6 col-lg-4 mb-3">
                        <div class="card {{ $account->show_in_petty_cash ? 'border-success' : 'border-secondary' }}">
                            <div class="card-body p-3">
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox"
                                           class="custom-control-input expense-account-checkbox"
                                           name="visible_accounts[]"
                                           value="{{ $account->id }}"
                                           id="account_{{ $account->id }}"
                                           {{ $account->show_in_petty_cash ? 'checked' : '' }}>
                                    <label class="custom-control-label" for="account_{{ $account->id }}">
                                        <strong>{{ $account->code }}</strong>
                                        <br>
                                        <small class="text-muted">{{ $account->name }}</small>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>

            @if($expenseAccounts->isEmpty())
                <div class="alert alert-warning">
                    <i class="fas fa-exclamation-triangle"></i> No expense accounts found.
                </div>
            @endif
        </div>

        <div class="card-footer">
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-save"></i> Save Settings
            </button>
            <a href="{{ route('admin.pettycash.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to Petty Cash
            </a>
        </div>
    </form>
</div>

@stop

@section('js')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const selectAllCheckbox = document.getElementById('select_all');
        const accountCheckboxes = document.querySelectorAll('.expense-account-checkbox');

        // Select/Deselect all functionality
        selectAllCheckbox.addEventListener('change', function() {
            accountCheckboxes.forEach(checkbox => {
                checkbox.checked = this.checked;
                updateCardBorder(checkbox);
            });
        });

        // Update select all checkbox when individual checkboxes change
        accountCheckboxes.forEach(checkbox => {
            checkbox.addEventListener('change', function() {
                updateSelectAllState();
                updateCardBorder(this);
            });
        });

        // Update card border color based on checkbox state
        function updateCardBorder(checkbox) {
            const card = checkbox.closest('.card');
            if (checkbox.checked) {
                card.classList.remove('border-secondary');
                card.classList.add('border-success');
            } else {
                card.classList.remove('border-success');
                card.classList.add('border-secondary');
            }
        }

        // Update "Select All" checkbox state
        function updateSelectAllState() {
            const totalCheckboxes = accountCheckboxes.length;
            const checkedCheckboxes = document.querySelectorAll('.expense-account-checkbox:checked').length;

            if (checkedCheckboxes === 0) {
                selectAllCheckbox.checked = false;
                selectAllCheckbox.indeterminate = false;
            } else if (checkedCheckboxes === totalCheckboxes) {
                selectAllCheckbox.checked = true;
                selectAllCheckbox.indeterminate = false;
            } else {
                selectAllCheckbox.checked = false;
                selectAllCheckbox.indeterminate = true;
            }
        }

        // Initialize select all state
        updateSelectAllState();
    });
</script>
@stop
