@extends('adminlte::page')

@section('title', 'Petty Cash Approvals')

@section('content_header')
<h1>Petty Cash Approvals</h1>
@stop

@section('content')

<div class="card">
    <div class="card-body p-0">

        @if($expenses->isEmpty())
            <div class="p-3 text-center text-muted">
                No pending petty cash expenses 🎉
            </div>
        @else

        <table class="table table-striped table-hover">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Employee</th>
                    <th>Expense</th>
                    <th>Description</th>
                    <th class="text-right">Amount</th>
                    <th class="text-right">VAT</th>
                    <th class="text-center">VAT Claimable</th>
                    <th class="text-center">Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach($expenses as $expense)
                <tr>
                    <td>{{ \Carbon\Carbon::parse($expense->expense_date)->format('d-m-Y') }}</td>
                    <td>{{ $expense->user->name }}</td>
                    <td>{{ $expense->expenseAccount->code }} - {{ $expense->expenseAccount->name }}</td>
                    <td>{{ $expense->description }}</td>
                    <td class="text-right">{{ number_format($expense->amount, 2) }}</td>
                    <td class="text-right">
                        @if($expense->is_vat_inclusive && $expense->vat_amount > 0)
                            <span class="badge badge-info" title="VAT Inclusive">{{ number_format($expense->vat_amount, 2) }}</span>
                        @else
                            <span class="text-muted">—</span>
                        @endif
                    </td>
                    <td class="text-center">
                        @if($expense->is_vat_inclusive && $expense->vat_amount > 0)
                            <input type="checkbox"
                                   class="vat-claimable-checkbox"
                                   id="vat_claimable_{{ $expense->id }}"
                                   data-expense-id="{{ $expense->id }}"
                                   title="Check if VAT is claimable">
                        @else
                            <span class="text-muted">—</span>
                        @endif
                    </td>
                    <td class="text-center">

                        <a href="{{ route('admin.pettycash.approvals.show', $expense->id) }}"
                           class="btn btn-sm btn-info"
                           title="View Details">
                            <i class="fas fa-eye"></i>
                        </a>

                        <form method="POST"
                              action="{{ route('admin.pettycash.approvals.approve', $expense->id) }}"
                              class="approve-form-{{ $expense->id }}"
                              style="display:inline;">
                            @csrf
                            <input type="hidden" name="vat_claimable" id="vat_claimable_hidden_{{ $expense->id }}" value="0">
                            <button class="btn btn-sm btn-success"
                                    onclick="return confirmApprove({{ $expense->id }})"
                                    title="Approve">
                                <i class="fas fa-check"></i>
                            </button>
                        </form>

                        <button class="btn btn-sm btn-danger"
                                data-toggle="modal"
                                data-target="#rejectModal{{ $expense->id }}"
                                title="Reject">
                            <i class="fas fa-times"></i>
                        </button>

                        <!-- Reject Modal -->
                        <div class="modal fade" id="rejectModal{{ $expense->id }}">
                            <div class="modal-dialog">
                                <form method="POST"
                                      action="{{ route('admin.pettycash.approvals.reject', $expense->id) }}">
                                    @csrf
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title">Reject Expense</h5>
                                        </div>
                                        <div class="modal-body">
                                            <textarea name="reason"
                                                      class="form-control"
                                                      placeholder="Reason for rejection"
                                                      required></textarea>
                                        </div>
                                        <div class="modal-footer">
                                            <button class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                            <button class="btn btn-danger">Reject</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>

                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>

        @endif

    </div>
</div>

@stop

@section('js')
<script>
function confirmApprove(expenseId) {
    // Get the checkbox value
    const checkbox = document.getElementById('vat_claimable_' + expenseId);
    const hiddenInput = document.getElementById('vat_claimable_hidden_' + expenseId);

    // Update hidden input based on checkbox state
    if (checkbox && checkbox.checked) {
        hiddenInput.value = '1';
    } else if (checkbox) {
        hiddenInput.value = '0';
    }

    return confirm('Approve this expense?');
}
</script>
@stop
