@extends('adminlte::page')

@section('content')
<h3>General Ledger</h3>

@foreach($ledgers as $ledger)
    <h4>{{ $ledger['account']->code }} - {{ $ledger['account']->name }}</h4>
    <table class="table table-bordered table-sm">
        <thead>
            <tr>
                <th>Date</th>
                <th>Description</th>
                <th class="text-end">Debit</th>
                <th class="text-end">Credit</th>
                <th class="text-end">Balance</th>
            </tr>
        </thead>
        <tbody>
            @php $balance = 0; @endphp
            @foreach($ledger['transactions'] as $t)
                @php
                    $balance += $t->debit - $t->credit;
                @endphp
                <tr>
                    <td>{{ $t->created_at->toDateString() }}</td>
                    <td>{{ $t->description ?? '-' }}</td>
                    <td class="text-end">{{ $t->debit > 0 ? number_format($t->debit, 2) : '' }}</td>
                    <td class="text-end">{{ $t->credit > 0 ? number_format($t->credit, 2) : '' }}</td>
                    <td class="text-end">{{ number_format($balance, 2) }}</td>
                </tr>
            @endforeach
            <tr>
                <th colspan="4" class="text-end">Final Balance</th>
                <th class="text-end">{{ number_format($balance, 2) }}</th>
            </tr>
        </tbody>
    </table>
@endforeach
@endsection
