@extends('adminlte::page')

@section('css')
    {{-- jQuery UI CSS --}}
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
@endsection

@section('js')
    {{-- jQuery and jQuery UI --}}
    <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.js"></script>

    <script>
        $(document).ready(function() {
            $(".datepicker").datepicker({
                dateFormat: 'yy-mm-dd',
                changeMonth: true,
                changeYear: true
            }).on('keydown paste', function(e){
                e.preventDefault();
            });
        });
    </script>
@endsection

@if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

@section('content')
<div class="container">
    <h2>Record Expense</h2>
    <form action="{{ route('admin.journals.record-expense.store') }}" method="POST">
        @csrf

        <div class="mb-3">
            <label>Date</label>
            <input type="text" name="date" class="form-control datepicker" id="date" placeholder="Select Date" readonly>
        </div>

        <div class="mb-3">
            <label>Description</label>
            <textarea name="description" class="form-control" required></textarea>
        </div>

        <div class="mb-3">
            <label>Allocation</label>
            <input name="allocation" type="text" class="form-control">
        </div>

        <div class="mb-3">
            <label>Invoice No.</label>
            <input type="text" name="inv_number" class="form-control" placeholder="Enter Invoice Number">

        </div>

        <div class="mb-3">
            <label>Invoice Date</label>
            <input name="inv_date" type="text" class="form-control datepicker" placeholder="Select Invoice Date" readonly>
        </div>



        <div class="mb-3">
            <label>Vendor</label>
            <select name="vendor_id" class="form-select">
                <option value="">-- Select Vendor --</option>
                @foreach($vendors as $vendor)
                    <option value="{{ $vendor->id }}">{{ $vendor->company_name }}</option>
                @endforeach
            </select>
        </div>

        <div class="mb-3">
            <label>Equipment</label>
            <select name="machine_id" class="form-select">
                <option value="">-- Select Equipment --</option>
                @foreach($equipments as $eq)
                    <option value="{{ $eq->id }}">{{ $eq->eq_id }} - {{ $eq->description }}</option>
                @endforeach
            </select>
        </div>

        <div class="row mb-3">
            <div class="col-md-6">
                <label>Debit Account</label>
                <select name="debit_account_id" class="form-select" required>
                    <option value="">-- Select Debit Account --</option>
                    @foreach($expenseAccounts as $acc)
                        <option value="{{ $acc->id }}">{{ $acc->code }} - {{ $acc->name }}</option>
                    @endforeach
                </select>
            </div>

            <div class="col-md-6">
                <label>Credit Account</label>
                <select name="credit_account_id" class="form-select" required>
                    <option value="">-- Select Credit Account --</option>
                    @foreach($cashAccounts as $acc)
                        <option value="{{ $acc->id }}">{{ $acc->code }} - {{ $acc->name }}</option>
                    @endforeach
                </select>
            </div>
        </div>

        <div class="mb-3">
            <label>Amount</label>
            <input type="number" step="0.01" min="0" name="amount" class="form-control" value="0.00">
        </div>

        <button type="submit" class="btn btn-success">Record Expense</button>
    </form>
</div>
@endsection


