@extends('adminlte::page')

@section('content')
<div class="container">
    <h2>Post Journal for Invoice #{{ $invoice->invoice_number }}</h2>

    <form action="{{ route('admin.journals.store') }}" method="POST">
        @csrf

        {{-- Invoice Info --}}
        <div class="row mb-3">
            <div class="col-md-4">
                <label>Invoice ID</label>
                <input type="text" class="form-control" value="{{ $invoice->id }}" readonly>
                <input type="hidden" name="inv_id" value="{{ $invoice->id }}">
            </div>
            <div class="col-md-4">
                <label>Invoice Date</label>
                <input type="date" name="inv_date" class="form-control" value="{{ $invoice->invoice_date }}" readonly>
            </div>
            <div class="col-md-4">
                <label>Customer</label>
                <input type="text" class="form-control" value="{{ $invoice->customer->name }}" readonly>
                <input type="hidden" name="customer_id" value="{{ $invoice->customer_id }}">
            </div>
        </div>

        {{-- Journal Meta --}}
        <div class="mb-3">
            <label>Journal Date</label>
            <input name="date" type="date" value="{{ now()->toDateString() }}" class="form-control" required>
        </div>

        <div class="mb-3">
            <label>Description</label>
            <input name="description" type="text" class="form-control"
                   value="Auto-generated journal for Invoice #{{ $invoice->invoice_number }}" required>
        </div>

        {{-- Journal Transactions --}}
        @php
            $amount = $invoice->total;
            $index = 0;
        @endphp

        @if($status === 'partially_paid')
            @for($i = 0; $i < 2; $i++)
                <div class="row mb-2">
                    <div class="col-md-6">
                        <label>Debit Account</label>
                        <select name="transactions[{{ $index }}][debit_account_id]" class="form-control" required>
                            @foreach($debitAccounts as $acc)
                                <option value="{{ $acc->id }}">{{ $acc->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label>Amount</label>
                        <input type="number" name="transactions[{{ $index }}][debit]" class="form-control"
                               value="{{ $amount / 2 }}" step="0.01" required>
                    </div>
                </div>
                @php $index++; @endphp
            @endfor

            <div class="row mb-2">
                <div class="col-md-6">
                    <label>Credit Account</label>
                    <select name="transactions[{{ $index }}][credit_account_id]" class="form-control" required>
                        @foreach($creditAccounts as $acc)
                            <option value="{{ $acc->id }}">{{ $acc->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-6">
                    <label>Amount</label>
                    <input type="number" name="transactions[{{ $index }}][credit]" class="form-control"
                           value="{{ $amount }}" step="0.01" required>
                </div>
            </div>

        @elseif($status === 'submitted')
            <div class="row mb-2">
                <div class="col-md-6">
                    <label>Debit Account</label>
                    <input type="text" class="form-control" value="Accounts Receivable (1100)" readonly>
                    <input type="hidden" name="transactions[0][debit_account_id]" value="{{ $debitAccounts->firstWhere('code', 1100)->id }}">
                </div>
                <div class="col-md-6">
                    <label>Amount</label>
                    <input type="number" name="transactions[0][debit]" class="form-control"
                           value="{{ $amount }}" step="0.01" readonly>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-md-6">
                    <label>Credit Account</label>
                    <select name="transactions[0][credit_account_id]" class="form-control" required>
                        @foreach($creditAccounts as $acc)
                            <option value="{{ $acc->id }}">{{ $acc->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-6">
                    <label>Amount</label>
                    <input type="number" name="transactions[0][credit]" class="form-control"
                           value="{{ $amount }}" step="0.01" required>
                </div>
            </div>

        @else
            <div class="row mb-2">
                <div class="col-md-6">
                    <label>Debit Account</label>
                    <select name="transactions[0][debit_account_id]" class="form-control" required>
                        @foreach($debitAccounts as $acc)
                            <option value="{{ $acc->id }}">{{ $acc->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-6">
                    <label>Amount</label>
                    <input type="number" name="transactions[0][debit]" class="form-control"
                           value="{{ $amount }}" step="0.01" required>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-md-6">
                    <label>Credit Account</label>
                    <select name="transactions[0][credit_account_id]" class="form-control" required>
                        @foreach($creditAccounts as $acc)
                            <option value="{{ $acc->id }}">{{ $acc->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-6">
                    <label>Amount</label>
                    <input type="number" name="transactions[0][credit]" class="form-control"
                           value="{{ $amount }}" step="0.01" required>
                </div>
            </div>
        @endif

        <button type="submit" class="btn btn-success mt-4">Post Journal Entry</button>
    </form>
</div>
@endsection
