@extends('adminlte::page')

@section('title', 'Invoice Details')

@section('content')
<div class="container">
    <h2>Invoice Details</h2>

    <table class="table table-bordered">
        <tr>
            <th>Invoice Number</th>
            <td>{{ $invoice->invoice_number }}</td>
        </tr>
        <tr>
            <th>Invoice Date</th>
            <td>{{ $invoice->invoice_date }}</td>
        </tr>
        <tr>
            <th>Customer</th>
            <td>{{ $invoice->customer->name ?? '—' }}</td>
        </tr>
        <tr>
            <th>Quote</th>
            <td>{{ optional($invoice->quote)->quote_number ?? '—' }}</td>
        </tr>
        <tr>
            <th>Project Site</th>
            <td>{{ $invoice->project_site ?? '—' }}</td>
        </tr>
        <tr>
            <th>Subject</th>
            <td>{{ $invoice->subject }}</td>
        </tr>

        <tr>
            <th>Total</th>
            <td>{{ number_format($invoice->total, 2) }}</td>
        </tr>
        <tr>
            <th>Amount Paid</th>
            <td>{{ number_format($invoice->amount_paid, 2) }}</td>
        </tr>
        <tr>
            <th>Discount</th>
            <td>{{ number_format($invoice->discount_given, 2) }}</td>
        </tr>
        <tr>
            <th>Outstanding</th>
            <td class="text-danger">
                {{ number_format($invoice->total - $invoice->amount_paid - $invoice->discount_given, 2) }}
            </td>
        </tr>
        <tr>
            <th>Status</th>
            <td>{{ ucfirst($invoice->status) }}</td>
        </tr>
    </table>

    <hr>

    <h4>Journal Entries</h4>
    @php $journals = $invoice->journalEntries; @endphp
    @if($journals->isEmpty())
        <p class="text-muted">No journal entries found.</p>
    @else
        <table class="table table-bordered">
            <thead class="table-light">
                <tr>
                    <th>Date</th>
                    <th>Account</th>
                    <th>AC Code</th>
                    <th>Debit</th>
                    <th>Credit</th>
                </tr>
            </thead>
            <tbody>
                @foreach($journals as $journal)
                    @foreach($journal->transactions as $i => $t)
                        <tr>
                            @if($i === 0)
                                <td rowspan="{{ $journal->transactions->count() + 1 }}">
                                    {{ \Carbon\Carbon::parse($journal->date)->format('d/m/Y') }}
                                </td>
                            @endif
                            <td>{{ $t->account->name }}</td>
                            <td>{{ $t->account->code ?? '—' }}</td>
                            <td>{{ $t->debit > 0 ? number_format($t->debit, 2) : '' }}</td>
                            <td>{{ $t->credit > 0 ? number_format($t->credit, 2) : '' }}</td>
                        </tr>
                    @endforeach
                    <tr class="table-secondary">
                        <td colspan="5"><em>{{ $journal->description }}</em></td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endif

    <a href="{{ route('invoices.index') }}" class="btn btn-primary mt-4">Back to Invoices</a>
</div>
@endsection
