<form id="statusForm" data-id="{{ $invoice->id }}">
    @csrf

    <div class="mb-3"><strong>Invoice:</strong> {{ $invoice->invoice_number }}</div>
    <div class="mb-3"><strong>Date:</strong> {{ $invoice->invoice_date }}</div>
    <div class="mb-3"><strong>Total:</strong> {{ $invoice->total }}</div>
    <div class="mb-3"><strong>Customer:</strong> {{ $invoice->customer->name }}</div>

    <label>Status</label>

    @php
        $statusOrder = ['created', 'submitted', 'partially_paid', 'paid', 'cancelled'];
        $allowedStatuses = ['submitted', 'cancelled'];
        $currentIndex = array_search($invoice->status, $statusOrder);
    @endphp

    <select name="status" class="form-control mb-3">
        @foreach($allowedStatuses as $status)
            @php $statusIndex = array_search($status, $statusOrder); @endphp
            @if($statusIndex !== false && $statusIndex > $currentIndex)
                <option value="{{ $status }}">{{ ucfirst($status) }}</option>
            @endif
        @endforeach
    </select>

    <button type="submit" class="btn btn-primary">Update Status</button>
</form>
