@extends('adminlte::page')

@section('content')
<div class="container">
    <h2>Invoices</h2>
    <a href="{{ route('admin.invoices.create') }}" class="btn btn-primary mb-3">Create Invoice</a>

    <table class="table table-bordered table-hover">
        <thead>
            <tr>
                <th>Inv#</th>
                <th>Date</th>
                <th>Customer</th>
                <th>Subject</th>
                <th>Total</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($invoices as $invoice)
                <tr>
                    <td>
                        <a href="{{ route('admin.invoices.show', $invoice->id) }}">
                            {{ $invoice->invoice_number }}
                        </a>
                    </td>

                    <td>{{ $invoice->invoice_date }}</td>

                    <td>
                        <a href="{{ route('admin.customers.show', $invoice->customer_id) }}">
                            {{ $invoice->customer->name }}
                        </a>
                    </td>
                    <td>{{ $invoice->subject }}</td>

                    @php
                        $paidRatio = $invoice->amount_paid / $invoice->total;
                        $badge = $paidRatio >= 1 ? 'success' : ($paidRatio > 0 ? 'warning' : 'secondary');
                        $remaining = $invoice->total - $invoice->amount_paid - $invoice->discount_given;
                    @endphp

                    <td>
                        <span class="badge badge-{{ $badge }}">
                            {{ number_format($invoice->amount_paid, 2) }} / {{ number_format($invoice->total, 2) }}
                        </span><br>
                        <small class="text-muted">
                            Remaining: {{ number_format(max($remaining, 0), 2) }}
                        </small>
                    </td>

                    <td>{{ ucfirst($invoice->status) }}</td>

                    <td>
                        <form id="action-form-{{ $invoice->id }}" method="POST" action="{{ route('admin.invoices.destroy', $invoice->id) }}">
                            @csrf
                            @method('DELETE')

                            <div class="input-group">
                                <select class="form-control form-control-sm action-select" data-id="{{ $invoice->id }}">
                                    <option value="">Select Action</option>

                                    @if(!in_array($invoice->status, ['partially_paid', 'paid', 'cancelled']))
                                        <option value="edit">Edit</option>
                                    @endif
                                    @if(in_array($invoice->status, ['submitted', 'partially_paid']))
                                        <option value="payment">Receive Payment</option>
                                    @endif

                                    <option value="status">Change Status</option>
                                </select>

                                <div class="input-group-append">
                                    <button type="button" class="btn btn-sm btn-secondary" onclick="submitAction({{ $invoice->id }})">Go</button>
                                </div>
                            </div>
                        </form>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>

<!-- Modal for Status -->
<div class="modal fade" id="statusModal" tabindex="-1" role="dialog" aria-labelledby="statusModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Change Invoice Status</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span>&times;</span>
        </button>
      </div>
      <div class="modal-body" id="modalStatusBody">
        <!-- AJAX-loaded -->
      </div>
    </div>
  </div>
</div>
@endsection

@section('js')
<script>
    function submitAction(id) {
        const action = document.querySelector(`.action-select[data-id="${id}"]`).value;
        if (!action) return alert('Please select an action.');

        if (action === 'edit') {
            window.location.href = `/admin/invoices/${id}/edit`;
        } else if (action === 'status') {
            $.get(`/admin/invoices/${id}/status/modal`, function (res) {
                $('#modalStatusBody').html(res);
                $('#statusModal').modal('show');
            }).fail(function (err) {
                alert(err.responseJSON?.message || 'Failed to load status form.');
            });
        }
            else if (action === 'payment') {
                window.open(`/admin/invoices/${id}/receive-payment`, '_blank');
            }

    }

    // ✅ AJAX submit for status change
    $(document).on('submit', '#statusForm', function (e) {
        e.preventDefault();

        const form = $(this);
        const id = form.data('id');
        const status = form.find('[name="status"]').val();
        const token = form.find('[name="_token"]').val();

        $.post(`/admin/invoices/${id}/status/update`, {

            _token: token,
            status: status
        })
        .done(response => {
            if (response.redirect) {
                window.location.href = response.redirect;
            } else {
                $('#statusModal').modal('hide');
                location.reload(); // fallback
            }
        })
        .fail(xhr => {
            alert(xhr.responseJSON?.error || 'Failed to update status.');
        })
        .always(() => {
            submitBtn.prop('disabled', false);
        });
    });
</script>
@endsection

