@extends('adminlte::page')

@section('content')
<div class="container">
    <h2>Edit Invoice</h2>
        {{-- Payment Form --}}
    @if ($errors->any())
        <div class="alert alert-danger">
            <strong>There were some errors:</strong>
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    <form action="{{ route('invoices.update', $invoice->id) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="row">
            <div class="col-md-4 mb-3">
                <label>Invoice Number</label>
                <input type="text" name="invoice_number" class="form-control" value="{{ old('invoice_number', $invoice->invoice_number) }}" required>
            </div>
            <div class="col-md-4 mb-3">
                <label>Invoice Date</label>
                <input type="date" name="invoice_date" class="form-control" value="{{ old('invoice_date', $invoice->invoice_date) }}" required>
            </div>
            <div class="col-md-4 mb-3">
                <label>Customer</label>
                <select name="customer_id" class="form-control" required>
                    @foreach($customers as $customer)
                        <option value="{{ $customer->id }}" {{ $customer->id == $invoice->customer_id ? 'selected' : '' }}>{{ $customer->name }}</option>
                    @endforeach
                </select>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6 mb-3">
                <label>Subject</label>
                <input type="text" name="subject" class="form-control" value="{{ old('subject', $invoice->subject) }}" required>
            </div>
            <div class="col-md-6 mb-3">
                <label>Project Site</label>
                <input type="text" name="project_site" class="form-control" value="{{ old('project_site', $invoice->project_site) }}">
            </div>
        </div>

        <div class="row">
            <div class="col-md-6 mb-3">
                <label>Rental Start</label>
                <input type="date" name="rental_start" class="form-control" value="{{ old('rental_start', $invoice->rental_start) }}">
            </div>
            <div class="col-md-6 mb-3">
                <label>Rental End</label>
                <input type="date" name="rental_end" class="form-control" value="{{ old('rental_end', $invoice->rental_end) }}">
            </div>
        </div>

        <div class="row">
            <div class="col-md-6 mb-3">
                <label>Quote</label>
                <select name="quote_id" class="form-control">
                    <option value="">-- Optional --</option>
                    @foreach($quotes as $quote)
                        <option value="{{ $quote->id }}" {{ $quote->id == $invoice->quote_id ? 'selected' : '' }}>
                            {{ $quote->quote_number }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-6 mb-3">
                <label>Status</label>
                <select name="status" class="form-control">
                    @php $statuses = ['created', 'submitted', 'partially_paid', 'paid', 'cancelled']; @endphp
                    @foreach ($statuses as $status)
                        <option value="{{ $status }}" {{ $invoice->status === $status ? 'selected' : '' }}>
                            {{ ucfirst(str_replace('_', ' ', $status)) }}
                        </option>
                    @endforeach
                </select>
            </div>
        </div>

        <div class="row">
            <div class="col-md-3 mb-3">
                <label>Subtotal</label>
                <input type="number" name="subtotal" class="form-control" step="0.01" value="{{ old('subtotal', $invoice->subtotal) }}">
            </div>
            <div class="col-md-3 mb-3">
                <label>Discount</label>
                <input type="number" name="discount" class="form-control" step="0.01" value="{{ old('discount', $invoice->discount) }}">
            </div>
            <div class="col-md-3 mb-3">
                <label>Taxable Total</label>
                <input type="number" name="taxable_total" class="form-control" step="0.01" value="{{ old('taxable_total', $invoice->taxable_total) }}">
            </div>
            <div class="col-md-3 mb-3">
                <label>VAT (5%)</label>
                <input type="number" name="tax_total" class="form-control" step="0.01" value="{{ old('tax_total', $invoice->tax_total) }}">
            </div>
        </div>

        <div class="mb-3">
            <label>Total</label>
            <input type="number" name="total" class="form-control" step="0.01" value="{{ old('total', $invoice->total) }}" required>
        </div>

        <button type="submit" class="btn btn-success">Update Invoice</button>
    </form>
</div>
@endsection
