@extends('adminlte::page')

@section('content')
<div class="container">
    <h2>Edit Invoice Item</h2>
    <form action="{{ route('invoice_items.update', $invoiceItem->id) }}" method="POST">
        @csrf
        @method('PUT')
        <div class="mb-3">
            <label for="item_code" class="form-label">Item Code</label>
            <input type="text" name="item_code" value="{{ $invoiceItem->item_code }}" class="form-control" required>
        </div>
        <div class="mb-3">
            <label for="description" class="form-label">Description</label>
            <textarea name="description" class="form-control" required>{{ $invoiceItem->description }}</textarea>
        </div>
        <div class="mb-3">
            <label for="quantity" class="form-label">Quantity</label>
            <input type="number" name="quantity" value="{{ $invoiceItem->quantity }}" class="form-control" step="any" required>
        </div>
        <div class="mb-3">
            <label for="unit_price" class="form-label">Unit Price</label>
            <input type="number" name="unit_price" value="{{ $invoiceItem->unit_price }}" class="form-control" step="any" required>
        </div>
        <button type="submit" class="btn btn-success">Update</button>
    </form>
</div>
@endsection
