@extends('adminlte::page')

@section('title', 'Leave Application Details')

@section('content_header')
    <h1>Leave Application Details</h1>
@stop

@section('content')
    <div class="row">
        <div class="col-md-8 offset-md-2">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Application #{{ $leave->id }}</h3>
                    <div class="card-tools">
                        @switch($leave->status)
                            @case('pending')
                                <span class="badge badge-warning badge-lg">Pending</span>
                                @break
                            @case('manager_approved')
                                <span class="badge badge-info badge-lg">Manager Approved</span>
                                @break
                            @case('hr_approved')
                                <span class="badge badge-success badge-lg">Approved</span>
                                @break
                            @case('rejected')
                                <span class="badge badge-danger badge-lg">Rejected</span>
                                @break
                        @endswitch
                    </div>
                </div>
                <div class="card-body">
                    <table class="table table-sm">
                        <tr>
                            <th width="30%">Employee:</th>
                            <td>
                                {{ $leave->employee->full_name }}
                                <br>
                                <small class="text-muted">
                                    {{ $leave->employee->employee_id }} |
                                    {{ $leave->employee->department->name ?? 'N/A' }}
                                </small>
                            </td>
                        </tr>
                        <tr>
                            <th>Leave Type:</th>
                            <td>
                                {{ $leave->leaveType->name }}
                                @if($leave->leaveType->is_paid)
                                    <span class="badge badge-success">Paid</span>
                                @else
                                    <span class="badge badge-warning">Unpaid</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>Start Date:</th>
                            <td>{{ $leave->start_date->format('d M Y') }}</td>
                        </tr>
                        <tr>
                            <th>End Date:</th>
                            <td>{{ $leave->end_date->format('d M Y') }}</td>
                        </tr>
                        <tr>
                            <th>Total Days:</th>
                            <td><span class="badge badge-info">{{ $leave->total_days }} days</span></td>
                        </tr>
                        <tr>
                            <th>Reason:</th>
                            <td>{{ $leave->reason }}</td>
                        </tr>
                        <tr>
                            <th>Applied On:</th>
                            <td>{{ $leave->created_at->format('d M Y h:i A') }}</td>
                        </tr>
                    </table>

                    <hr>

                    <h5>Approval Status</h5>

                    <div class="timeline">
                        <div>
                            <i class="fas fa-paper-plane bg-info"></i>
                            <div class="timeline-item">
                                <span class="time"><i class="fas fa-clock"></i> {{ $leave->created_at->format('d M Y h:i A') }}</span>
                                <h3 class="timeline-header">Application Submitted</h3>
                                <div class="timeline-body">
                                    Leave application submitted by {{ $leave->employee->full_name }}
                                </div>
                            </div>
                        </div>

                        @if($leave->manager_approved_by)
                            <div>
                                <i class="fas fa-check bg-success"></i>
                                <div class="timeline-item">
                                    <span class="time"><i class="fas fa-clock"></i> {{ $leave->manager_approved_at->format('d M Y h:i A') }}</span>
                                    <h3 class="timeline-header">Manager Approved</h3>
                                    <div class="timeline-body">
                                        Approved by {{ $leave->managerApprover->name }}
                                        @if($leave->manager_comments)
                                            <br><strong>Comments:</strong> {{ $leave->manager_comments }}
                                        @endif
                                    </div>
                                </div>
                            </div>
                        @endif

                        @if($leave->hr_approved_by)
                            <div>
                                <i class="fas fa-check-double bg-success"></i>
                                <div class="timeline-item">
                                    <span class="time"><i class="fas fa-clock"></i> {{ $leave->hr_approved_at->format('d M Y h:i A') }}</span>
                                    <h3 class="timeline-header">HR Approved</h3>
                                    <div class="timeline-body">
                                        Approved by {{ $leave->hrApprover->name }}
                                        @if($leave->hr_comments)
                                            <br><strong>Comments:</strong> {{ $leave->hr_comments }}
                                        @endif
                                    </div>
                                </div>
                            </div>
                        @endif

                        @if($leave->status == 'rejected')
                            <div>
                                <i class="fas fa-times bg-danger"></i>
                                <div class="timeline-item">
                                    <h3 class="timeline-header">Application Rejected</h3>
                                    <div class="timeline-body">
                                        <strong>Reason:</strong> {{ $leave->rejection_reason }}
                                    </div>
                                </div>
                            </div>
                        @endif

                        <div>
                            <i class="fas fa-clock bg-gray"></i>
                        </div>
                    </div>

                    @if($leave->status == 'pending')
                        @can('approve leave as manager')
                            <div class="mt-3">
                                <button type="button" class="btn btn-success" data-toggle="modal" data-target="#managerApproveModal">
                                    <i class="fas fa-check"></i> Manager Approve
                                </button>
                                <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#rejectModal">
                                    <i class="fas fa-times"></i> Reject
                                </button>
                            </div>
                        @endcan
                    @endif

                    @if($leave->status == 'manager_approved')
                        @can('approve leave as hr')
                            <div class="mt-3">
                                <button type="button" class="btn btn-success" data-toggle="modal" data-target="#hrApproveModal">
                                    <i class="fas fa-check"></i> HR Approve
                                </button>
                                <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#rejectModal">
                                    <i class="fas fa-times"></i> Reject
                                </button>
                            </div>
                        @endcan
                    @endif
                </div>
                <div class="card-footer">
                    <a href="{{ route('admin.hr.leaves.index') }}" class="btn btn-default">Back to My Leaves</a>
                    @can('view all leaves')
                        <a href="{{ route('admin.hr.leaves.all') }}" class="btn btn-default">View All Leaves</a>
                    @endcan
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="managerApproveModal" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <form action="{{ route('admin.hr.leaves.manager-approve', $leave) }}" method="POST">
                    @csrf
                    <div class="modal-header">
                        <h5 class="modal-title">Manager Approval</h5>
                        <button type="button" class="close" data-dismiss="modal">
                            <span>&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="manager_comments">Comments (Optional)</label>
                            <textarea name="manager_comments" id="manager_comments" class="form-control" rows="3"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-success">Approve</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="hrApproveModal" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <form action="{{ route('admin.hr.leaves.hr-approve', $leave) }}" method="POST">
                    @csrf
                    <div class="modal-header">
                        <h5 class="modal-title">HR Approval</h5>
                        <button type="button" class="close" data-dismiss="modal">
                            <span>&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="hr_comments">Comments (Optional)</label>
                            <textarea name="hr_comments" id="hr_comments" class="form-control" rows="3"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-success">Approve</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="rejectModal" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <form action="{{ route('admin.hr.leaves.reject', $leave) }}" method="POST">
                    @csrf
                    <div class="modal-header">
                        <h5 class="modal-title">Reject Leave Application</h5>
                        <button type="button" class="close" data-dismiss="modal">
                            <span>&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="rejection_reason">Reason for Rejection <span class="text-danger">*</span></label>
                            <textarea name="rejection_reason" id="rejection_reason" class="form-control" rows="3" required></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Reject</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@stop
