@extends('adminlte::page')

@section('title', 'My Leaves')

@section('content_header')
    <h1>My Leave Applications</h1>
@stop

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Your Leave History</h3>
            <div class="card-tools">
                @can('apply leave')
                    <a href="{{ route('admin.hr.leaves.create') }}" class="btn btn-sm btn-primary">
                        <i class="fas fa-plus"></i> Apply for Leave
                    </a>
                @endcan
            </div>
        </div>
        <div class="card-body">
            <table class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>Leave Type</th>
                        <th>Start Date</th>
                        <th>End Date</th>
                        <th>Days</th>
                        <th>Status</th>
                        <th>Applied On</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($leaves as $leave)
                        <tr>
                            <td>{{ $leave->leaveType->name }}</td>
                            <td>{{ $leave->start_date->format('d M Y') }}</td>
                            <td>{{ $leave->end_date->format('d M Y') }}</td>
                            <td><span class="badge badge-info">{{ $leave->total_days }} days</span></td>
                            <td>
                                @switch($leave->status)
                                    @case('pending')
                                        <span class="badge badge-warning">Pending</span>
                                        @break
                                    @case('manager_approved')
                                        <span class="badge badge-info">Manager Approved</span>
                                        @break
                                    @case('hr_approved')
                                        <span class="badge badge-success">Approved</span>
                                        @break
                                    @case('rejected')
                                        <span class="badge badge-danger">Rejected</span>
                                        @break
                                @endswitch
                            </td>
                            <td>{{ $leave->created_at->format('d M Y') }}</td>
                            <td>
                                <a href="{{ route('admin.hr.leaves.show', $leave) }}" class="btn btn-sm btn-info">
                                    <i class="fas fa-eye"></i> View
                                </a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="text-center">No leave applications found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="card-footer">
            {{ $leaves->links() }}
        </div>
    </div>
@stop
