@extends('adminlte::page')

@section('title', 'All Leave Applications')

@section('content_header')
    <h1>All Leave Applications</h1>
@stop

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Leave Applications Overview</h3>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('admin.hr.leaves.all') }}" class="mb-3">
                <div class="row">
                    <div class="col-md-3">
                        <select name="status" class="form-control">
                            <option value="">All Status</option>
                            <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                            <option value="manager_approved" {{ request('status') == 'manager_approved' ? 'selected' : '' }}>Manager Approved</option>
                            <option value="hr_approved" {{ request('status') == 'hr_approved' ? 'selected' : '' }}>HR Approved</option>
                            <option value="rejected" {{ request('status') == 'rejected' ? 'selected' : '' }}>Rejected</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <select name="employee_id" class="form-control">
                            <option value="">All Employees</option>
                            @foreach($employees as $emp)
                                <option value="{{ $emp->id }}" {{ request('employee_id') == $emp->id ? 'selected' : '' }}>
                                    {{ $emp->full_name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-2">
                        <input type="date" name="start_date" class="form-control" placeholder="Start Date" value="{{ request('start_date') }}">
                    </div>
                    <div class="col-md-2">
                        <input type="date" name="end_date" class="form-control" placeholder="End Date" value="{{ request('end_date') }}">
                    </div>
                    <div class="col-md-2">
                        <button type="submit" class="btn btn-primary btn-block">Filter</button>
                    </div>
                </div>
            </form>

            <table class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>Employee</th>
                        <th>Leave Type</th>
                        <th>Dates</th>
                        <th>Days</th>
                        <th>Status</th>
                        <th>Applied On</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($leaves as $leave)
                        <tr>
                            <td>
                                {{ $leave->employee->full_name }}
                                <br>
                                <small class="text-muted">
                                    {{ $leave->employee->employee_id }} |
                                    {{ $leave->employee->department->name ?? 'N/A' }}
                                </small>
                            </td>
                            <td>
                                {{ $leave->leaveType->name }}
                                @if($leave->leaveType->is_paid)
                                    <br><span class="badge badge-success">Paid</span>
                                @else
                                    <br><span class="badge badge-warning">Unpaid</span>
                                @endif
                            </td>
                            <td>
                                {{ $leave->start_date->format('d M Y') }}
                                <br>to
                                <br>{{ $leave->end_date->format('d M Y') }}
                            </td>
                            <td><span class="badge badge-info">{{ $leave->total_days }} days</span></td>
                            <td>
                                @switch($leave->status)
                                    @case('pending')
                                        <span class="badge badge-warning">Pending</span>
                                        @break
                                    @case('manager_approved')
                                        <span class="badge badge-info">Manager Approved</span>
                                        <br><small class="text-muted">by {{ $leave->managerApprover->name }}</small>
                                        @break
                                    @case('hr_approved')
                                        <span class="badge badge-success">Approved</span>
                                        <br><small class="text-muted">by {{ $leave->hrApprover->name }}</small>
                                        @break
                                    @case('rejected')
                                        <span class="badge badge-danger">Rejected</span>
                                        @break
                                @endswitch
                            </td>
                            <td>{{ $leave->created_at->format('d M Y') }}</td>
                            <td>
                                <a href="{{ route('admin.hr.leaves.show', $leave) }}" class="btn btn-sm btn-info">
                                    <i class="fas fa-eye"></i> View
                                </a>

                                @if($leave->status == 'pending')
                                    @can('approve leave as manager')
                                        <form action="{{ route('admin.hr.leaves.manager-approve', $leave) }}" method="POST" class="d-inline">
                                            @csrf
                                            <button type="submit" class="btn btn-sm btn-success" onclick="return confirm('Approve this leave application?')">
                                                <i class="fas fa-check"></i>
                                            </button>
                                        </form>
                                    @endcan
                                @endif

                                @if($leave->status == 'manager_approved')
                                    @can('approve leave as hr')
                                        <form action="{{ route('admin.hr.leaves.hr-approve', $leave) }}" method="POST" class="d-inline">
                                            @csrf
                                            <button type="submit" class="btn btn-sm btn-success" onclick="return confirm('Approve this leave application?')">
                                                <i class="fas fa-check"></i>
                                            </button>
                                        </form>
                                    @endcan
                                @endif
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="text-center">No leave applications found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="card-footer">
            {{ $leaves->links() }}
        </div>
    </div>
@stop
