@extends('adminlte::page')

@section('title', 'Employee Details')

@section('content_header')
    <h1>Employee Details: {{ $employee->full_name }}</h1>
@stop

@section('content')
    <div class="row">
        <div class="col-md-4">
            <div class="card">
                <div class="card-body text-center">
                    @if($employee->photo)
                        <img src="{{ asset('storage/' . $employee->photo) }}" alt="{{ $employee->full_name }}" class="img-fluid rounded-circle" style="max-width: 200px;">
                    @else
                        <div class="bg-secondary rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 200px; height: 200px;">
                            <i class="fas fa-user fa-5x text-white"></i>
                        </div>
                    @endif
                    <h3 class="mt-3">{{ $employee->full_name }}</h3>
                    @if($employee->full_name_ar)
                        <p class="text-muted">{{ $employee->full_name_ar }}</p>
                    @endif
                    <p><strong>{{ $employee->employee_id }}</strong></p>
                    <p>
                        @switch($employee->status)
                            @case('active')
                                <span class="badge badge-success badge-lg">Active</span>
                                @break
                            @case('on_leave')
                                <span class="badge badge-warning badge-lg">On Leave</span>
                                @break
                            @case('suspended')
                                <span class="badge badge-danger badge-lg">Suspended</span>
                                @break
                            @case('terminated')
                                <span class="badge badge-dark badge-lg">Terminated</span>
                                @break
                        @endswitch
                    </p>
                    <div class="mt-3">
                        @can('edit employees')
                            <a href="{{ route('admin.hr.employees.edit', $employee) }}" class="btn btn-primary btn-block">
                                <i class="fas fa-edit"></i> Edit
                            </a>
                        @endcan
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">User Account</h3>
                </div>
                <div class="card-body">
                    @if($employee->user_id)
                        <div class="alert alert-success">
                            <i class="fas fa-check-circle"></i> This employee has a user account.
                        </div>
                        <table class="table table-sm">
                            <tr>
                                <th>User Name:</th>
                                <td>{{ $employee->user->name }}</td>
                            </tr>
                            <tr>
                                <th>Email:</th>
                                <td>{{ $employee->user->email }}</td>
                            </tr>
                            <tr>
                                <th>Role:</th>
                                <td>
                                    @foreach($employee->user->roles as $role)
                                        <span class="badge badge-info">{{ ucfirst($role->name) }}</span>
                                    @endforeach
                                </td>
                            </tr>
                        </table>
                    @else
                        <div class="alert alert-warning">
                            <i class="fas fa-exclamation-triangle"></i> This employee does not have a user account yet.
                        </div>
                        @if($employee->email)
                            @can('manage employees')
                                <a href="{{ route('admin.hr.employees.create-user', $employee) }}" class="btn btn-success btn-block">
                                    <i class="fas fa-user-plus"></i> Create User Account
                                </a>
                            @endcan
                        @else
                            <p class="text-danger"><i class="fas fa-times-circle"></i> Employee must have an email address to create a user account.</p>
                        @endif
                    @endif
                </div>
            </div>
        </div>

        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Personal Information</h3>
                </div>
                <div class="card-body">
                    <table class="table table-sm">
                        <tr>
                            <th width="30%">Nationality:</th>
                            <td>{{ $employee->nationality }}</td>
                        </tr>
                        <tr>
                            <th>Gender:</th>
                            <td>{{ ucfirst($employee->gender) }}</td>
                        </tr>
                        <tr>
                            <th>Date of Birth:</th>
                            <td>{{ $employee->date_of_birth->format('d M Y') }} ({{ $employee->age }} years old)</td>
                        </tr>
                        <tr>
                            <th>Marital Status:</th>
                            <td>{{ ucfirst($employee->marital_status) }}</td>
                        </tr>
                    </table>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Contact Information</h3>
                </div>
                <div class="card-body">
                    <table class="table table-sm">
                        <tr>
                            <th width="30%">Email:</th>
                            <td>{{ $employee->email ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <th>Phone:</th>
                            <td>{{ $employee->phone }}</td>
                        </tr>
                        @if($employee->phone_2)
                            <tr>
                                <th>Phone 2:</th>
                                <td>{{ $employee->phone_2 }}</td>
                            </tr>
                        @endif
                        @if($employee->address)
                            <tr>
                                <th>Address:</th>
                                <td>{{ $employee->address }}</td>
                            </tr>
                        @endif
                    </table>
                </div>
            </div>

            @if($employee->emergency_contact_name)
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Emergency Contact</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-sm">
                            <tr>
                                <th width="30%">Name:</th>
                                <td>{{ $employee->emergency_contact_name }}</td>
                            </tr>
                            <tr>
                                <th>Phone:</th>
                                <td>{{ $employee->emergency_contact_phone }}</td>
                            </tr>
                            <tr>
                                <th>Relationship:</th>
                                <td>{{ $employee->emergency_contact_relationship }}</td>
                            </tr>
                        </table>
                    </div>
                </div>
            @endif

            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Employment Details</h3>
                </div>
                <div class="card-body">
                    <table class="table table-sm">
                        <tr>
                            <th width="30%">Department:</th>
                            <td>{{ $employee->department->name ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <th>Designation:</th>
                            <td>{{ $employee->designation->name ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <th>Reporting Manager:</th>
                            <td>{{ $employee->reportingManager->name ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <th>Employment Type:</th>
                            <td>{{ ucfirst(str_replace('-', ' ', $employee->employment_type)) }}</td>
                        </tr>
                        <tr>
                            <th>Joining Date:</th>
                            <td>{{ $employee->joining_date->format('d M Y') }} ({{ $employee->tenure }} years)</td>
                        </tr>
                        <tr>
                            <th>Probation Period:</th>
                            <td>{{ $employee->probation_period_days }} days</td>
                        </tr>
                        @if($employee->confirmation_date)
                            <tr>
                                <th>Confirmation Date:</th>
                                <td>{{ $employee->confirmation_date->format('d M Y') }}</td>
                            </tr>
                        @endif
                        @if($employee->status == 'terminated')
                            <tr>
                                <th>Termination Date:</th>
                                <td>{{ $employee->termination_date?->format('d M Y') }}</td>
                            </tr>
                            <tr>
                                <th>Termination Reason:</th>
                                <td>{{ $employee->termination_reason }}</td>
                            </tr>
                        @endif
                    </table>
                </div>
            </div>

            @if($employee->currentSalary)
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Current Salary</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-sm">
                            <tr>
                                <th width="30%">Basic Salary:</th>
                                <td>{{ number_format($employee->currentSalary->basic_salary, 2) }} AED</td>
                            </tr>
                            <tr>
                                <th>Housing Allowance:</th>
                                <td>{{ number_format($employee->currentSalary->housing_allowance, 2) }} AED</td>
                            </tr>
                            <tr>
                                <th>Transport Allowance:</th>
                                <td>{{ number_format($employee->currentSalary->transport_allowance, 2) }} AED</td>
                            </tr>
                            <tr>
                                <th>Other Allowances:</th>
                                <td>{{ number_format($employee->currentSalary->other_allowances, 2) }} AED</td>
                            </tr>
                            <tr>
                                <th><strong>Gross Salary:</strong></th>
                                <td><strong>{{ number_format($employee->currentSalary->gross_salary, 2) }} AED</strong></td>
                            </tr>
                            <tr>
                                <th>Effective From:</th>
                                <td>{{ $employee->currentSalary->effective_from->format('d M Y') }}</td>
                            </tr>
                        </table>
                    </div>
                </div>
            @endif
        </div>
    </div>
@stop
