@extends('adminlte::page')

@section('title', 'Create User Account')

@section('content_header')
    <h1>Create User Account for {{ $employee->full_name }}</h1>
@stop

@section('content')
    <div class="row">
        <div class="col-md-8 offset-md-2">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">User Account Details</h3>
                </div>
                <form action="{{ route('admin.hr.employees.store-user', $employee) }}" method="POST">
                    @csrf
                    <div class="card-body">
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i> Creating a user account will allow this employee to log in to the system.
                        </div>

                        <div class="form-group">
                            <label for="name">Full Name <span class="text-danger">*</span></label>
                            <input type="text" name="name" id="name" class="form-control @error('name') is-invalid @enderror" value="{{ old('name', $employee->full_name) }}" required>
                            @error('name')<span class="invalid-feedback">{{ $message }}</span>@enderror
                        </div>

                        <div class="form-group">
                            <label for="email">Email <span class="text-danger">*</span></label>
                            <input type="email" name="email" id="email" class="form-control @error('email') is-invalid @enderror" value="{{ old('email', $employee->email) }}" required>
                            @error('email')<span class="invalid-feedback">{{ $message }}</span>@enderror
                            <small class="form-text text-muted">This email will be used for login.</small>
                        </div>

                        <div class="form-group">
                            <label for="password">Password <span class="text-danger">*</span></label>
                            <input type="password" name="password" id="password" class="form-control @error('password') is-invalid @enderror" required>
                            @error('password')<span class="invalid-feedback">{{ $message }}</span>@enderror
                            <small class="form-text text-muted">Minimum 8 characters.</small>
                        </div>

                        <div class="form-group">
                            <label for="password_confirmation">Confirm Password <span class="text-danger">*</span></label>
                            <input type="password" name="password_confirmation" id="password_confirmation" class="form-control" required>
                        </div>

                        <div class="form-group">
                            <label for="role">Role <span class="text-danger">*</span></label>
                            <select name="role" id="role" class="form-control @error('role') is-invalid @enderror" required>
                                <option value="">Select Role</option>
                                @foreach($roles as $role)
                                    <option value="{{ $role->name }}" {{ old('role') == $role->name ? 'selected' : '' }}>
                                        {{ ucfirst($role->name) }}
                                    </option>
                                @endforeach
                            </select>
                            @error('role')<span class="invalid-feedback">{{ $message }}</span>@enderror
                            <small class="form-text text-muted">Select the role that defines this user's permissions.</small>
                        </div>

                        <div class="alert alert-warning">
                            <i class="fas fa-exclamation-triangle"></i> <strong>Important:</strong> Please save or share these login credentials with the employee securely.
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-user-plus"></i> Create User Account
                        </button>
                        <a href="{{ route('admin.hr.employees.show', $employee) }}" class="btn btn-default">Cancel</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
@stop

@section('js')
<script>
    // Show password toggle
    document.getElementById('password').addEventListener('input', function() {
        const strength = this.value.length >= 8 ? 'Strong' : 'Weak';
        const color = this.value.length >= 8 ? 'success' : 'danger';

        let strengthBadge = document.getElementById('password-strength');
        if (!strengthBadge) {
            strengthBadge = document.createElement('small');
            strengthBadge.id = 'password-strength';
            strengthBadge.className = 'form-text';
            this.parentElement.appendChild(strengthBadge);
        }

        strengthBadge.className = `form-text text-${color}`;
        strengthBadge.textContent = `Password strength: ${strength}`;
    });
</script>
@stop
