@extends('adminlte::page')

@section('title', 'Department Details')

@section('content_header')
    <h1>Department: {{ $department->name }}</h1>
@stop

@section('content')
    <div class="row">
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Department Information</h3>
                </div>
                <div class="card-body">
                    <table class="table table-sm">
                        <tr>
                            <th>Name:</th>
                            <td>{{ $department->name }}</td>
                        </tr>
                        @if($department->name_ar)
                            <tr>
                                <th>Name (Arabic):</th>
                                <td>{{ $department->name_ar }}</td>
                            </tr>
                        @endif
                        <tr>
                            <th>Manager:</th>
                            <td>{{ $department->manager->name ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <th>Status:</th>
                            <td>
                                @if($department->is_active)
                                    <span class="badge badge-success">Active</span>
                                @else
                                    <span class="badge badge-secondary">Inactive</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>Total Employees:</th>
                            <td><span class="badge badge-info">{{ $department->employees->count() }}</span></td>
                        </tr>
                    </table>

                    @if($department->description)
                        <div class="mt-3">
                            <h5>Description</h5>
                            <p>{{ $department->description }}</p>
                        </div>
                    @endif

                    <div class="mt-3">
                        @can('manage departments')
                            <a href="{{ route('admin.hr.departments.edit', $department) }}" class="btn btn-primary btn-block">
                                <i class="fas fa-edit"></i> Edit Department
                            </a>
                        @endcan
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Department Employees</h3>
                </div>
                <div class="card-body">
                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>Employee ID</th>
                                <th>Name</th>
                                <th>Designation</th>
                                <th>Phone</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($department->employees as $employee)
                                <tr>
                                    <td>{{ $employee->employee_id }}</td>
                                    <td>
                                        <a href="{{ route('admin.hr.employees.show', $employee) }}">
                                            {{ $employee->full_name }}
                                        </a>
                                    </td>
                                    <td>{{ $employee->designation->name ?? 'N/A' }}</td>
                                    <td>{{ $employee->phone }}</td>
                                    <td>
                                        @switch($employee->status)
                                            @case('active')
                                                <span class="badge badge-success">Active</span>
                                                @break
                                            @case('on_leave')
                                                <span class="badge badge-warning">On Leave</span>
                                                @break
                                            @case('suspended')
                                                <span class="badge badge-danger">Suspended</span>
                                                @break
                                            @case('terminated')
                                                <span class="badge badge-dark">Terminated</span>
                                                @break
                                        @endswitch
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="text-center">No employees in this department.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@stop
