@extends('adminlte::page')

@section('title', 'Approve Attendance')

@section('content_header')
    <h1>Approve Attendance</h1>
@stop

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Pending Attendance Approvals</h3>
        </div>
        <div class="card-body">
            <!-- Desktop View -->
            <div class="d-none d-md-block">
                <table class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Employee</th>
                        <th>Check In</th>
                        <th>Check Out</th>
                        <th>Total Hours</th>
                        <th>OT</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($attendances as $attendance)
                        <tr>
                            <td>{{ $attendance->date->format('d M Y') }}</td>
                            <td>
                                {{ $attendance->employee->full_name }}
                                <br>
                                <small class="text-muted">
                                    {{ $attendance->employee->employee_id }} |
                                    {{ $attendance->employee->department->name ?? 'N/A' }}
                                </small>
                            </td>
                            <td>{{ $attendance->check_in ? \Carbon\Carbon::parse($attendance->check_in)->format('h:i A') : 'N/A' }}</td>
                            <td>{{ $attendance->check_out ? \Carbon\Carbon::parse($attendance->check_out)->format('h:i A') : 'N/A' }}</td>
                            <td>
                                @if($attendance->total_hours)
                                    <span class="badge badge-info">{{ number_format($attendance->total_hours, 2) }} hrs</span>
                                @else
                                    N/A
                                @endif
                            </td>
                            <td>
                                @if($attendance->total_hours)
                                    @php
                                        $overtime = $attendance->total_hours - 9;
                                        $otClass = $overtime >= 0 ? 'text-success' : 'text-danger';
                                        $otSign = $overtime >= 0 ? '+' : '';
                                    @endphp
                                    <span class="{{ $otClass }} font-weight-bold">
                                        {{ $otSign }}{{ number_format($overtime, 2) }} hrs
                                    </span>
                                @else
                                    <span class="text-muted">N/A</span>
                                @endif
                            </td>
                            <td>
                                @switch($attendance->status)
                                    @case('present')
                                        <span class="badge badge-success">Present</span>
                                        @break
                                    @case('absent')
                                        <span class="badge badge-danger">Absent</span>
                                        @break
                                    @case('late')
                                        <span class="badge badge-warning">Late</span>
                                        @break
                                    @case('half_day')
                                        <span class="badge badge-info">Half Day</span>
                                        @break
                                    @case('on_leave')
                                        <span class="badge badge-secondary">On Leave</span>
                                        @break
                                @endswitch
                            </td>
                            <td>
                                <button type="button" class="btn btn-sm btn-success" data-toggle="modal" data-target="#approveModal{{ $attendance->id }}">
                                    <i class="fas fa-check"></i> Approve
                                </button>

                                <div class="modal fade" id="approveModal{{ $attendance->id }}" tabindex="-1" role="dialog">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <form action="{{ route('admin.hr.attendance.approve.submit', $attendance) }}" method="POST">
                                                @csrf
                                                <div class="modal-header">
                                                    <h5 class="modal-title">Approve Attendance</h5>
                                                    <button type="button" class="close" data-dismiss="modal">
                                                        <span>&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body">
                                                    <p>Approving attendance for <strong>{{ $attendance->employee->full_name }}</strong> on <strong>{{ $attendance->date->format('d M Y') }}</strong></p>
                                                    <div class="form-group">
                                                        <label for="notes{{ $attendance->id }}">Notes (Optional)</label>
                                                        <textarea name="notes" id="notes{{ $attendance->id }}" class="form-control" rows="3">{{ $attendance->notes }}</textarea>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                                    <button type="submit" class="btn btn-success">Approve</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="text-center">No pending attendance approvals.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
            </div>

            <!-- Mobile View -->
            <div class="d-md-none">
                @forelse($attendances as $attendance)
                    <div class="card mb-3">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-start mb-2">
                                <div>
                                    <h5 class="mb-0">{{ $attendance->date->format('d M Y') }}</h5>
                                    <small class="text-muted">{{ $attendance->employee->full_name }}</small>
                                </div>
                                @switch($attendance->status)
                                    @case('present')
                                        <span class="badge badge-success">Present</span>
                                        @break
                                    @case('absent')
                                        <span class="badge badge-danger">Absent</span>
                                        @break
                                    @case('late')
                                        <span class="badge badge-warning">Late</span>
                                        @break
                                    @case('half_day')
                                        <span class="badge badge-info">Half Day</span>
                                        @break
                                    @case('on_leave')
                                        <span class="badge badge-secondary">On Leave</span>
                                        @break
                                @endswitch
                            </div>

                            <div class="row mb-2">
                                <div class="col-6">
                                    <small class="text-muted">Check In</small>
                                    <div class="font-weight-bold">
                                        {{ $attendance->check_in ? \Carbon\Carbon::parse($attendance->check_in)->format('h:i A') : 'N/A' }}
                                    </div>
                                </div>
                                <div class="col-6">
                                    <small class="text-muted">Check Out</small>
                                    <div class="font-weight-bold">
                                        {{ $attendance->check_out ? \Carbon\Carbon::parse($attendance->check_out)->format('h:i A') : 'N/A' }}
                                    </div>
                                </div>
                            </div>

                            <div class="row mb-3">
                                <div class="col-6">
                                    <small class="text-muted">Total Hours</small>
                                    <div class="font-weight-bold">
                                        {{ $attendance->total_hours ? number_format($attendance->total_hours, 2) . ' hrs' : 'N/A' }}
                                    </div>
                                </div>
                                <div class="col-6">
                                    <small class="text-muted">OT</small>
                                    <div>
                                        @if($attendance->total_hours)
                                            @php
                                                $overtime = $attendance->total_hours - 9;
                                                $otClass = $overtime >= 0 ? 'text-success' : 'text-danger';
                                                $otSign = $overtime >= 0 ? '+' : '';
                                            @endphp
                                            <span class="{{ $otClass }} font-weight-bold">
                                                {{ $otSign }}{{ number_format($overtime, 2) }} hrs
                                            </span>
                                        @else
                                            <span class="text-muted">N/A</span>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <button type="button" class="btn btn-sm btn-success btn-block" data-toggle="modal" data-target="#approveModal{{ $attendance->id }}">
                                <i class="fas fa-check"></i> Approve Attendance
                            </button>

                            <div class="modal fade" id="approveModal{{ $attendance->id }}" tabindex="-1" role="dialog">
                                <div class="modal-dialog" role="document">
                                    <div class="modal-content">
                                        <form action="{{ route('admin.hr.attendance.approve.submit', $attendance) }}" method="POST">
                                            @csrf
                                            <div class="modal-header">
                                                <h5 class="modal-title">Approve Attendance</h5>
                                                <button type="button" class="close" data-dismiss="modal">
                                                    <span>&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <p>Approving attendance for <strong>{{ $attendance->employee->full_name }}</strong> on <strong>{{ $attendance->date->format('d M Y') }}</strong></p>
                                                <div class="form-group">
                                                    <label for="notes{{ $attendance->id }}">Notes (Optional)</label>
                                                    <textarea name="notes" id="notes{{ $attendance->id }}" class="form-control" rows="3">{{ $attendance->notes }}</textarea>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                                <button type="submit" class="btn btn-success">Approve</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @empty
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i> No pending attendance approvals.
                    </div>
                @endforelse
            </div>
        </div>
        <div class="card-footer">
            {{ $attendances->links() }}
        </div>
    </div>
@stop
