@extends('adminlte::page')

@section('content')
<div class="container">
    <h2>Customer Details</h2>

    <div class="card mb-4">
        <div class="card-header">
            {{ $customer->name }}
        </div>
        <div class="card-body">
            <p><strong>Email:</strong> {{ $customer->email }}</p>
            <p><strong>Phone:</strong> {{ $customer->phone }}</p>
            <p><strong>Address:</strong> {{ $customer->address }}</p>
        </div>
    </div>

    {{-- Invoice Summary --}}
    @php
        $invoiceCount = $customer->invoices->count();
        $totalAmount = $customer->invoices->sum('total');
        $paidAmount = $customer->invoices->sum('amount_paid');
        $discount = $customer->invoices->sum('discount_given');
        $balance = $totalAmount - $paidAmount - $discount;
    @endphp

    <div class="card mb-3">
        <div class="card-header bg-light"><strong>Invoices Summary</strong></div>
        <div class="card-body">
            <div class="row text-center">
                <div class="col-md-3">
                    <div><strong>Total Invoices</strong></div>
                    <div>{{ $invoiceCount }}</div>
                </div>
                <div class="col-md-3">
                    <div><strong>Invoice Total</strong></div>
                    <div>{{ number_format($totalAmount, 2) }}</div>
                </div>
                <div class="col-md-3">
                    <div><strong>Paid Total</strong></div>
                    <div>{{ number_format($paidAmount, 2) }}</div>
                </div>
                <div class="col-md-3">
                    <div><strong>Outstanding</strong></div>
                    <div class="text-danger">{{ number_format($balance, 2) }}</div>
                </div>
            </div>
        </div>
    </div>

    {{-- Invoices Table --}}
    <div class="card">
        <div class="card-header bg-light"><strong>Invoices</strong></div>
        <div class="card-body p-0">
            @if($customer->invoices->isEmpty())
                <p class="p-3">No invoices found.</p>
            @else
                <table class="table table-bordered mb-0">
                    <thead class="table-light">
                        <tr>
                            <th>Invoice #</th>
                            <th>Date</th>
                            <th>Status</th>
                            <th>Total</th>
                            <th>Paid</th>
                            <th>Balance</th>
                            
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($customer->invoices as $inv)
                            <tr>
                                <td>
                                    <a href="{{ route('invoices.show', $inv->id) }}">
                                        {{ $inv->invoice_number }}
                                    </a>
                                </td>
                                <td>{{ $inv->invoice_date }}</td>
                                <td>{{ ucfirst($inv->status) }}</td>
                                <td>{{ number_format($inv->total, 2) }}</td>
                                <td>{{ number_format($inv->amount_paid, 2) }}</td>
                                <td>{{ number_format($inv->total - $inv->amount_paid - $inv->discount_given, 2) }}</td>
                                
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @endif
        </div>
    </div>
</div>
@endsection
