@extends('adminlte::page')

@section('content')
<div class="container">
    <h2>Edit Customer</h2>

    <form action="{{ route('customers.update', $customer->id) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="mb-3">
            <label for="name">Customer Name</label>
            <input type="text" name="name" class="form-control" value="{{ old('name', $customer->name) }}" required>
        </div>

        <div class="mb-3">
            <label for="license_no">License No.</label>
            <input type="text" name="license_no" class="form-control" value="{{ old('license_no', $customer->license_no) }}" required>
        </div>

        <div class="mb-3">
            <label for="trn">TRN</label>
            <input type="text" name="trn" class="form-control" value="{{ old('trn', $customer->trn) }}" required>
        </div>

        <div class="mb-3">
            <label for="address">Address</label>
            <textarea name="address" class="form-control">{{ old('address', $customer->address) }}</textarea>
        </div>

        <div class="mb-3">
            <label for="email">Email</label>
            <input type="email" name="email" class="form-control" value="{{ old('email', $customer->email) }}">
        </div>

        <div class="mb-3">
            <label for="phone">Phone</label>
            <input type="text" name="phone" class="form-control" value="{{ old('phone', $customer->phone) }}">
        </div>

        <button type="submit" class="btn btn-primary">Update Customer</button>
    </form>
</div>
@endsection
