@extends('adminlte::page')

@section('content')
<div class="container">
    <h2>Customer Contacts</h2>
    <a href="{{ route('customer_contacts.create') }}" class="btn btn-primary mb-3">Create Customer Contact</a>
    <table class="table">
        <thead>
            <tr>
                <th>Name</th>
                <th>Mobile</th>
                <th>Email</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($customerContacts as $contact)
                <tr>
                    <td>{{ $contact->name }}</td>
                    <td>{{ $contact->mobile1 }}</td>
                    <td>{{ $contact->email }}</td>
                    <td>
                        <a href="{{ route('customer_contacts.edit', $contact->id) }}" class="btn btn-warning">Edit</a>
                        <form action="{{ route('customer_contacts.destroy', $contact->id) }}" method="POST" style="display:inline;">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger">Delete</button>
                        </form>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
