@extends('adminlte::page')

@section('content')
<div class="container">
    <h2>{{ isset($account) ? 'Edit' : 'Create' }} Account</h2>
    <form action="{{ isset($account) ? route('admin.accounts.update', $account) : route('admin.accounts.store') }}" method="POST">
        @csrf
        @if(isset($account)) @method('PUT') @endif

        <input name="code" value="{{ old('code', $account->code ?? '') }}" required placeholder="Code" class="form-control mb-2">
        <input name="name" value="{{ old('name', $account->name ?? '') }}" required placeholder="Name" class="form-control mb-2">

        <select name="type" class="form-select mb-2" required>
            @foreach(['asset', 'liability', 'equity', 'income', 'expense', 'cogs'] as $type)
                <option value="{{ $type }}" {{ (old('type', $account->type ?? '') == $type) ? 'selected' : '' }}>{{ ucfirst($type) }}</option>
            @endforeach
        </select>

        <select name="parent_id" id="parent_id" class="form-select mb-2">
            <option value="">None</option>
            @foreach($accounts as $acc)
                <option value="{{ $acc->id }}" {{ (old('parent_id', $account->parent_id ?? '') == $acc->id) ? 'selected' : '' }}>
                    {{ $acc->code }} - {{ $acc->name }}
                </option>
            @endforeach
        </select>

        <div class="mb-3" id="user_select_div" style="display: none;">
            <label for="user_id" class="form-label">Assign to User <span class="text-danger">*</span></label>
            <select name="user_id" id="user_id" class="form-select">
                <option value="">Select User</option>
                @foreach($users as $user)
                    <option value="{{ $user->id }}" {{ old('user_id', $account->user_id ?? '') == $user->id ? 'selected' : '' }}>
                        {{ $user->name }} ({{ $user->email }})
                    </option>
                @endforeach
            </select>
            <small class="form-text text-muted">This petty cash account will be assigned to the selected user.</small>
        </div>

        <div class="form-check mb-2">
            <input class="form-check-input" type="checkbox" name="is_posting" id="is_posting"
                   {{ old('is_posting', $account->is_posting ?? false) ? 'checked' : '' }}>
            <label class="form-check-label" for="is_posting">
                Is Posting Account?
            </label>
        </div>

        <button type="submit" class="btn btn-success">{{ isset($account) ? 'Update' : 'Create' }}</button>
    </form>
</div>
@endsection

@section('js')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const parentSelect = document.getElementById('parent_id');
        const userSelectDiv = document.getElementById('user_select_div');
        const userSelect = document.getElementById('user_id');
        const pettyCashAccountId = {{ $pettyCashAccountId ?? 'null' }};

        function toggleUserSelect() {
            const selectedParentId = parseInt(parentSelect.value);

            if (selectedParentId === pettyCashAccountId) {
                userSelectDiv.style.display = 'block';
                userSelect.required = true;
            } else {
                userSelectDiv.style.display = 'none';
                userSelect.required = false;
                userSelect.value = '';
            }
        }

        parentSelect.addEventListener('change', toggleUserSelect);

        // Check on page load
        toggleUserSelect();
    });
</script>
@endsection
