import './bootstrap';

/**
 * Prevent Double Form Submission
 *
 * This script automatically disables submit buttons after form submission
 * to prevent accidental duplicate submissions across the entire application.
 */
document.addEventListener('DOMContentLoaded', function() {
    // Get all forms on the page
    const forms = document.querySelectorAll('form');

    forms.forEach(form => {
        form.addEventListener('submit', function(e) {
            // Find all submit buttons in this form
            const submitButtons = this.querySelectorAll('button[type="submit"], input[type="submit"]');

            // Disable all submit buttons
            submitButtons.forEach(button => {
                button.disabled = true;

                // Add visual feedback
                if (button.tagName === 'BUTTON') {
                    const originalHTML = button.innerHTML;
                    button.setAttribute('data-original-html', originalHTML);

                    // Add spinner and "Processing..." text
                    button.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Processing...';
                }
            });

            // Re-enable buttons after 5 seconds as a safety measure
            // (in case form validation fails or navigation doesn't happen)
            setTimeout(() => {
                submitButtons.forEach(button => {
                    button.disabled = false;

                    if (button.tagName === 'BUTTON' && button.hasAttribute('data-original-html')) {
                        button.innerHTML = button.getAttribute('data-original-html');
                        button.removeAttribute('data-original-html');
                    }
                });
            }, 5000);
        });
    });
});
