<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class HRPermissionsSeeder extends Seeder
{
    public function run(): void
    {
        // HR Module Permissions
        $permissions = [
            // Departments
            'manage departments',
            'view departments',
            
            // Designations
            'manage designations',
            'view designations',
            
            // Employees
            'manage employees',
            'view employees',
            'create employees',
            'edit employees',
            'delete employees',
            'view employee documents',
            'manage employee documents',
            
            // Attendance
            'manage attendance',
            'view attendance',
            'mark own attendance',
            'approve attendance',
            
            // Leave Management
            'manage leave types',
            'apply leave',
            'view own leaves',
            'view all leaves',
            'approve leave as manager',
            'approve leave as hr',
            'reject leave',
            
            // Public Holidays
            'manage public holidays',
            'view public holidays',
            
            // Salary & Payroll
            'manage salary structures',
            'view salary structures',
            'process payroll',
            'view payroll',
            'approve payroll',
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission]);
        }

        // Assign permissions to admin role
        $adminRole = Role::where('name', 'admin')->first();
        if ($adminRole) {
            $adminRole->givePermissionTo($permissions);
        }

        // Create HR role with specific permissions
        $hrRole = Role::firstOrCreate(['name' => 'hr']);
        $hrPermissions = [
            'view departments',
            'view designations',
            'manage employees',
            'view employees',
            'create employees',
            'edit employees',
            'view employee documents',
            'manage employee documents',
            'view attendance',
            'approve attendance',
            'view all leaves',
            'approve leave as hr',
            'reject leave',
            'view public holidays',
            'manage salary structures',
            'view salary structures',
            'process payroll',
            'view payroll',
        ];
        $hrRole->syncPermissions($hrPermissions);

        // Create Manager role
        $managerRole = Role::firstOrCreate(['name' => 'manager']);
        $managerPermissions = [
            'view departments',
            'view designations',
            'view employees',
            'view attendance',
            'approve attendance',
            'view all leaves',
            'approve leave as manager',
            'view public holidays',
        ];
        $managerRole->syncPermissions($managerPermissions);

        // Update user role with basic HR permissions
        $userRole = Role::where('name', 'user')->first();
        if ($userRole) {
            $userRole->givePermissionTo([
                'mark own attendance',
                'apply leave',
                'view own leaves',
                'view public holidays',
            ]);
        }
    }
}
