<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class AccountsTableSeeder extends Seeder
{
    public function run()
    {
        $accounts = [
            
            ['code' => '1003', 'name' => 'Bank Account - ADIB', 'type' => 'asset', 'parent_code' => '1000', 'is_posting' => true],
            ['code' => '1004', 'name' => 'Petty Cash', 'type' => 'asset', 'parent_code' => '1000', 'is_posting' => true],
            ['code' => '1005', 'name' => 'Mobile Wallet', 'type' => 'asset', 'parent_code' => '1000', 'is_posting' => true],
            ['code' => '1006', 'name' => 'Credit Card', 'type' => 'liability', 'parent_code' => '1000', 'is_posting' => true],
            ['code' => '1100', 'name' => 'Accounts Receivable', 'type' => 'asset', 'parent_code' => null, 'is_posting' => true],
            ['code' => '1200', 'name' => 'Rental Equipment', 'type' => 'asset', 'parent_code' => null, 'is_posting' => false],
            ['code' => '1201', 'name' => 'Generators', 'type' => 'asset', 'parent_code' => '1200', 'is_posting' => true],
            ['code' => '1202', 'name' => 'Cables & Accessories', 'type' => 'asset', 'parent_code' => '1200', 'is_posting' => true],
            ['code' => '1203', 'name' => 'Vehicles', 'type' => 'asset', 'parent_code' => '1200', 'is_posting' => true],
            ['code' => '1300', 'name' => 'Accumulated Depreciation', 'type' => 'asset', 'parent_code' => null, 'is_posting' => false],
            ['code' => '1301', 'name' => 'Acc. Dep. - Equipment', 'type' => 'asset', 'parent_code' => '1300', 'is_posting' => true],
            ['code' => '1302', 'name' => 'Acc. Dep. - Vehicles', 'type' => 'asset', 'parent_code' => '1300', 'is_posting' => true],
            ['code' => '1400', 'name' => 'Inventory', 'type' => 'asset', 'parent_code' => null, 'is_posting' => false],
            ['code' => '1401', 'name' => 'Spare Parts', 'type' => 'asset', 'parent_code' => '1400', 'is_posting' => true],
            ['code' => '1402', 'name' => 'Fuel Stock', 'type' => 'asset', 'parent_code' => '1400', 'is_posting' => true],
            ['code' => '1500', 'name' => 'Prepaid Expenses', 'type' => 'asset', 'parent_code' => null, 'is_posting' => false],
            ['code' => '1501', 'name' => 'Prepaid Insurance', 'type' => 'asset', 'parent_code' => '1500', 'is_posting' => true],
            ['code' => '1502', 'name' => 'Prepaid Rent', 'type' => 'asset', 'parent_code' => '1500', 'is_posting' => true],
            ['code' => '2000', 'name' => 'Accounts Payable', 'type' => 'liability', 'parent_code' => null, 'is_posting' => true],
            ['code' => '2100', 'name' => 'Accrued Expenses', 'type' => 'liability', 'parent_code' => null, 'is_posting' => false],
            ['code' => '2101', 'name' => 'Salaries Payable', 'type' => 'liability', 'parent_code' => '2100', 'is_posting' => true],
            ['code' => '2102', 'name' => 'Utilities Payable', 'type' => 'liability', 'parent_code' => '2100', 'is_posting' => true],
            ['code' => '2200', 'name' => 'Loans Payable', 'type' => 'liability', 'parent_code' => null, 'is_posting' => false],
            ['code' => '2201', 'name' => 'Bank Loan', 'type' => 'liability', 'parent_code' => '2200', 'is_posting' => true],
            ['code' => '2202', 'name' => 'Equipment Financing', 'type' => 'liability', 'parent_code' => '2200', 'is_posting' => true],
            ['code' => '3000', 'name' => 'Owner\'s Equity', 'type' => 'equity', 'parent_code' => null, 'is_posting' => true],
            ['code' => '3100', 'name' => 'Retained Earnings', 'type' => 'equity', 'parent_code' => null, 'is_posting' => true],
            ['code' => '4000', 'name' => 'Rental Income', 'type' => 'income', 'parent_code' => null, 'is_posting' => false],
            ['code' => '4001', 'name' => 'Generator Rentals', 'type' => 'income', 'parent_code' => '4000', 'is_posting' => true],
            ['code' => '4002', 'name' => 'Cable/Accessory Rentals', 'type' => 'income', 'parent_code' => '4000', 'is_posting' => true],
            ['code' => '4100', 'name' => 'Delivery & Setup Charges', 'type' => 'income', 'parent_code' => null, 'is_posting' => false],
            ['code' => '4101', 'name' => 'Transport Charges', 'type' => 'income', 'parent_code' => '4100', 'is_posting' => true],
            ['code' => '4102', 'name' => 'Setup Fees', 'type' => 'income', 'parent_code' => '4100', 'is_posting' => true],
            ['code' => '4200', 'name' => 'Fuel Charges', 'type' => 'income', 'parent_code' => null, 'is_posting' => true],
            ['code' => '5000', 'name' => 'Equipment Maintenance', 'type' => 'cogs', 'parent_code' => null, 'is_posting' => false],
            ['code' => '5001', 'name' => 'Repairs', 'type' => 'cogs', 'parent_code' => '5000', 'is_posting' => true],
            ['code' => '5002', 'name' => 'Replacement Parts', 'type' => 'cogs', 'parent_code' => '5000', 'is_posting' => true],
            ['code' => '5100', 'name' => 'Subcontractor Costs', 'type' => 'cogs', 'parent_code' => null, 'is_posting' => true],
            ['code' => '6000', 'name' => 'Salaries & Wages', 'type' => 'expense', 'parent_code' => null, 'is_posting' => false],
            ['code' => '6001', 'name' => 'Staff', 'type' => 'expense', 'parent_code' => '6000', 'is_posting' => true],
            ['code' => '6002', 'name' => 'Drivers', 'type' => 'expense', 'parent_code' => '6000', 'is_posting' => true],
            ['code' => '6100', 'name' => 'Rent', 'type' => 'expense', 'parent_code' => null, 'is_posting' => false],
            ['code' => '6101', 'name' => 'Warehouse Rent', 'type' => 'expense', 'parent_code' => '6100', 'is_posting' => true],
            ['code' => '6102', 'name' => 'Office Rent', 'type' => 'expense', 'parent_code' => '6100', 'is_posting' => true],
            ['code' => '6200', 'name' => 'Utilities', 'type' => 'expense', 'parent_code' => null, 'is_posting' => false],
            ['code' => '6201', 'name' => 'Electricity', 'type' => 'expense', 'parent_code' => '6200', 'is_posting' => true],
            ['code' => '6202', 'name' => 'Water', 'type' => 'expense', 'parent_code' => '6200', 'is_posting' => true],
            ['code' => '6300', 'name' => 'Fuel Expenses', 'type' => 'expense', 'parent_code' => null, 'is_posting' => false],
            ['code' => '6301', 'name' => 'Generator Fuel', 'type' => 'expense', 'parent_code' => '6300', 'is_posting' => true],
            ['code' => '6302', 'name' => 'Vehicle Fuel', 'type' => 'expense', 'parent_code' => '6300', 'is_posting' => true],
            ['code' => '6400', 'name' => 'Vehicle Expenses', 'type' => 'expense', 'parent_code' => null, 'is_posting' => false],
            ['code' => '6401', 'name' => 'Maintenance', 'type' => 'expense', 'parent_code' => '6400', 'is_posting' => true],
            ['code' => '6402', 'name' => 'Insurance', 'type' => 'expense', 'parent_code' => '6400', 'is_posting' => true],
            ['code' => '6500', 'name' => 'Office Expenses', 'type' => 'expense', 'parent_code' => null, 'is_posting' => false],
            ['code' => '6501', 'name' => 'Stationery', 'type' => 'expense', 'parent_code' => '6500', 'is_posting' => true],
            ['code' => '6502', 'name' => 'Software Subscriptions', 'type' => 'expense', 'parent_code' => '6500', 'is_posting' => true],
            ['code' => '6600', 'name' => 'Depreciation Expense', 'type' => 'expense', 'parent_code' => null, 'is_posting' => false],
            ['code' => '6601', 'name' => 'Equipment Depreciation', 'type' => 'expense', 'parent_code' => '6600', 'is_posting' => true],
            ['code' => '6602', 'name' => 'Vehicle Depreciation', 'type' => 'expense', 'parent_code' => '6600', 'is_posting' => true],
            ['code' => '6700', 'name' => 'Marketing & Advertising', 'type' => 'expense', 'parent_code' => null, 'is_posting' => false],
            ['code' => '6701', 'name' => 'Online Ads', 'type' => 'expense', 'parent_code' => '6700', 'is_posting' => true],
            ['code' => '6702', 'name' => 'Flyers & Banners', 'type' => 'expense', 'parent_code' => '6700', 'is_posting' => true],
            ['code' => '6800', 'name' => 'Insurance', 'type' => 'expense', 'parent_code' => null, 'is_posting' => false],
            ['code' => '6801', 'name' => 'General Insurance', 'type' => 'expense', 'parent_code' => '6800', 'is_posting' => true],
            ['code' => '6802', 'name' => 'Equipment Insurance', 'type' => 'expense', 'parent_code' => '6800', 'is_posting' => true],
            ['code' => '6900', 'name' => 'Professional Fees', 'type' => 'expense', 'parent_code' => null, 'is_posting' => false],
            ['code' => '6901', 'name' => 'Accounting', 'type' => 'expense', 'parent_code' => '6900', 'is_posting' => true],
            ['code' => '6902', 'name' => 'Legal', 'type' => 'expense', 'parent_code' => '6900', 'is_posting' => true],
        ];

        $codeToId = [];

        foreach ($accounts as $account) {
            $parentId = $account['parent_code'] ? ($codeToId[$account['parent_code']] ?? null) : null;

            $id = DB::table('accounts')->insertGetId([
                'code' => $account['code'],
                'name' => $account['name'],
                'type' => $account['type'],
                'parent_id' => $parentId,
                'is_posting' => $account['is_posting'],
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            $codeToId[$account['code']] = $id;
        }
    }
}
