<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('petty_cash_expenses', function (Blueprint $table) {
            $table->boolean('is_vat_inclusive')->default(false)->after('amount');
            $table->decimal('vat_amount', 10, 2)->default(0)->after('is_vat_inclusive');
            $table->decimal('amount_excluding_vat', 10, 2)->default(0)->after('vat_amount');
        });

        Schema::table('invoices', function (Blueprint $table) {
            $table->decimal('vat_amount', 10, 2)->default(0)->after('tax_total');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('petty_cash_expenses', function (Blueprint $table) {
            $table->dropColumn(['is_vat_inclusive', 'vat_amount', 'amount_excluding_vat']);
        });

        Schema::table('invoices', function (Blueprint $table) {
            $table->dropColumn('vat_amount');
        });
    }
};
