<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateQuotesTableMakeAmountsNullable extends Migration
{
    public function up()
    {
        Schema::table('quotes', function (Blueprint $table) {
            $table->decimal('subtotal', 12, 2)->nullable()->default(0)->change();
            $table->decimal('discount', 12, 2)->nullable()->default(0)->change();
            $table->decimal('taxable_total', 12, 2)->nullable()->default(0)->change();
            $table->decimal('tax', 12, 2)->nullable()->default(0)->change();
        });
    }

    public function down()
    {
        Schema::table('quotes', function (Blueprint $table) {
            $table->decimal('subtotal', 12, 2)->nullable(false)->default(null)->change();
            $table->decimal('discount', 12, 2)->nullable(false)->default(0)->change();
            $table->decimal('taxable_total', 12, 2)->nullable(false)->default(null)->change();
            $table->decimal('tax', 12, 2)->nullable(false)->default(null)->change();
        });
    }
}

