<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInvoicesTable extends Migration
{
    public function up(): void
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->id();
            $table->string('invoice_number')->unique();
            $table->date('invoice_date');

            
            $table->unsignedBigInteger('customer_id')->constrained()->onDelete('restrict');
            $table->unsignedBigInteger('customer_contact_id')->nullable()->constrained()->onDelete('set null');
            $table->unsignedBigInteger('quote_id')->nullable()->constrained()->onDelete('set null');

            $table->text('project_site')->nullable();
            $table->date('rental_start')->nullable();
            $table->date('rental_end')->nullable();

            $table->decimal('subtotal', 12, 2);
            $table->decimal('discount', 12, 2)->default(0);
            $table->decimal('taxable_total', 12, 2);
            $table->decimal('tax_total', 12, 2);
            $table->decimal('total', 12, 2);

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('invoices');
    }
}

