<?php

return [
    // Navbar items:
    [
        'type' => 'navbar-search',
        'text' => 'search',
        'topnav_right' => true,
    ],
    [
        'type' => 'fullscreen-widget',
        'topnav_right' => true,
    ],

    // Sidebar items:
    [
        'type' => 'sidebar-menu-search',
        'text' => 'search',
    ],

    // Dashboard
    [
        'text' => 'Dashboard',
        'url'  => 'user/dashboard',
        'icon' => 'fas fa-home',
    ],

    // HR Module for Employees
    ['header' => 'My HR'],

    // Attendance
    [
        'text' => 'Attendance',
        'icon' => 'fas fa-calendar-check',
        'can'  => 'mark own attendance',
        'submenu' => [
            [
                'text' => 'Mark Attendance',
                'url'  => 'admin/hr/attendance/mark',
                'icon' => 'fas fa-check-circle',
                'can'  => 'mark own attendance',
            ],
            [
                'text' => 'My Attendance History',
                'url'  => 'admin/hr/attendance',
                'icon' => 'fas fa-history',
                'can'  => 'view attendance',
            ],
        ],
    ],

    // Leave Management
    [
        'text' => 'Leave Management',
        'icon' => 'fas fa-calendar-times',
        'can'  => 'apply leave',
        'submenu' => [
            [
                'text' => 'My Leaves',
                'url'  => 'admin/hr/leaves/my-leaves',
                'icon' => 'fas fa-list',
                'can'  => 'view own leaves',
            ],
            [
                'text' => 'Apply Leave',
                'url'  => 'admin/hr/leaves/create',
                'icon' => 'fas fa-plus',
                'can'  => 'apply leave',
            ],
        ],
    ],

    // Petty Cash
    ['header' => 'Finance'],

    [
        'text' => 'My Petty Cash',
        'icon' => 'fas fa-wallet',
        'can'  => 'view own petty cash',
        'submenu' => [
            [
                'text' => 'My Ledger',
                'url'  => 'admin/pettycash/my-ledger',
                'icon' => 'fas fa-book',
                'can'  => 'view own petty cash',
            ],
            [
                'text' => 'Add Expense',
                'url'  => 'admin/pettycash/my-expense',
                'icon' => 'fas fa-plus',
                'can'  => 'add petty cash expense',
            ],
        ],
    ],
];
