<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PettyCashExpense extends Model
{
    protected $fillable = [
        'user_id',
        'petty_cash_account_id',
        'expense_account_id',
        'expense_date',
        'amount',
        'is_vat_inclusive',
        'vat_amount',
        'vat_claimable',
        'amount_excluding_vat',
        'description',
        'receipt_images',
        'status',
        'approved_by',
        'approved_at',
        'rejection_reason'
    ];

    protected $casts = [
        'receipt_images' => 'array',
        'expense_date' => 'date',
        'approved_at' => 'datetime',
    ];

    public function user() {
        return $this->belongsTo(User::class);
    }

    public function approvedBy() {
        return $this->belongsTo(User::class, 'approved_by');
    }

    public function expenseAccount() {
        return $this->belongsTo(Account::class, 'expense_account_id');
    }

    public function pettyCashAccount() {
        return $this->belongsTo(Account::class, 'petty_cash_account_id');
    }
}
