<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class JournalEntry extends Model
{
    use HasFactory;

    protected $fillable = ['user_id', 'date', 'description', 'allocation', 'inv_id', 'inv_date', 'customer_id', 'vendor_id', 'Equipment_id'];

    protected $casts = [
        'date' => 'date',
        'inv_date' => 'date',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function transactions()
    {
        return $this->hasMany(JournalTransaction::class);
    }
}
