<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Item extends Model
{
    use HasFactory;

    // Primary key is not 'id', it's 'code'
    protected $primaryKey = 'code';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'code',
        'name',
        'description',
    ];

    // Relationships

    // An item can appear in many invoice items
    public function invoiceItems()
    {
        return $this->hasMany(InvoiceItem::class, 'item_code', 'code');
    }
}


