<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Invoice extends Model
{
    use HasFactory;

    protected $fillable = [
        'invoice_number',
        'invoice_date',
        'customer_id',
        'customer_contact_id',
        'po_number',
        'quote_id',
        'project_site',
        'rental_start',
        'rental_end',
        'subtotal',
        'taxable_total',
        'discount',
        'tax_total',
        'vat_amount',
        'total',
        'status',
        'is_recorded_in_journal',
        'amount_paid',
        'discount_given',
        'subject',


    ];

    // Relationships

    // An invoice belongs to a customer
    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    // An invoice may belong to a specific customer contact
    public function customerContact()
    {
        return $this->belongsTo(CustomerContact::class);
    }

    // An invoice may be based on a quote
    public function quote()
    {
        return $this->belongsTo(Quote::class);
    }

    // An invoice has many invoice items
    public function items()
    {
        return $this->hasMany(\App\Models\InvoiceItem::class);
    }

    public function journalEntries()
    {
        return $this->hasMany(\App\Models\JournalEntry::class, 'inv_id', 'invoice_number');
    }


}

