<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Customer extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'license_no',
        'trn',
        'address',
        'email',
        'phone',
    ];

    // Relationships

    // One customer has many contacts
    public function contacts()
    {
        return $this->hasMany(CustomerContact::class);
    }

    // One customer can have many invoices
    public function invoices()
    {
        return $this->hasMany(Invoice::class);
    }

    // One customer can have many quotes
    public function quotes()
    {
        return $this->hasMany(Quote::class);
    }
}

