<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;

class LoginController extends Controller
{
    use AuthenticatesUsers;

    protected function redirectTo()
    {
        if (auth()->user()->hasRole('admin')) {
            return '/admin/dashboard';
        } elseif (auth()->user()->hasRole('user')) {
            return '/user/dashboard';
        }

        return '/'; // fallback
    }

    /**
     * The user has been authenticated.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  mixed  $user
     * @return mixed
     */
    protected function authenticated(Request $request, $user)
    {
        // Clear the intended URL from session to prevent unauthorized redirects
        $request->session()->forget('url.intended');

        // Redirect based on user role
        if ($user->hasRole('admin')) {
            return redirect('/admin/dashboard');
        } elseif ($user->hasRole('user')) {
            return redirect('/user/dashboard');
        }

        return redirect('/');
    }
}
