<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Quote;
use App\Models\Customer;
use Illuminate\Http\Request;

class QuoteController extends Controller
{
    public function index()
    {
        $quotes = Quote::with('customer')->get();
        return view('admin.quotes.index', compact('quotes'));
    }

    public function create()
    {
        $customers = Customer::all();
        return view('admin.quotes.create', compact('customers'));
    }

    public function store(Request $request)
    {
        Quote::create($request->all());
        return redirect()->route('quotes.index')->with('success', 'Quote created.');
    }

    public function edit(Quote $quote)
    {
        $customers = Customer::all();
        return view('admin.quotes.edit', compact('quote', 'customers'));
    }

    public function update(Request $request, Quote $quote)
    {
        $quote->update($request->all());
        return redirect()->route('quotes.index')->with('success', 'Quote updated.');
    }

    public function destroy(Quote $quote)
    {
        $quote->delete();
        return redirect()->route('quotes.index')->with('success', 'Quote deleted.');
    }
}
