<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\InvoiceItem;
use App\Models\Invoice;
use App\Models\Item;
use Illuminate\Http\Request;

class InvoiceItemController extends Controller
{
    public function index()
    {
        $invoiceItems = InvoiceItem::with('invoice', 'item')->get();
        return view('admin.invoice_items.index', compact('invoiceItems'));
    }

    public function create()
    {
        $invoices = Invoice::all();
        $items = Item::all();
        return view('admin.invoice_items.create', compact('invoices', 'items'));
    }

    public function store(Request $request)
    {
        InvoiceItem::create($request->all());
        return redirect()->route('invoice_items.index')->with('success', 'Item added.');
    }

    public function edit(InvoiceItem $invoiceItem)
    {
        $invoices = Invoice::all();
        $items = Item::all();
        return view('admin.invoice_items.edit', compact('invoiceItem', 'invoices', 'items'));
    }

    public function update(Request $request, InvoiceItem $invoiceItem)
    {
        $invoiceItem->update($request->all());
        return redirect()->route('invoice_items.index')->with('success', 'Item updated.');
    }

    public function destroy(InvoiceItem $invoiceItem)
    {
        $invoiceItem->delete();
        return redirect()->route('invoice_items.index')->with('success', 'Item deleted.');
    }
}
