<?php

namespace App\Http\Controllers\Admin\HR;

use App\Http\Controllers\Controller;
use App\Models\Designation;
use Illuminate\Http\Request;

class DesignationController extends Controller
{
    public function index()
    {
        $designations = Designation::withCount('employees')
            ->paginate(15);

        return view('admin.hr.designations.index', compact('designations'));
    }

    public function create()
    {
        return view('admin.hr.designations.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'name_ar' => 'nullable|string|max:255',
            'description' => 'nullable|string',
            'is_active' => 'boolean',
        ]);

        Designation::create($validated);

        return redirect()->route('admin.hr.designations.index')
            ->with('success', 'Designation created successfully.');
    }

    public function show(Designation $designation)
    {
        $designation->load(['employees.department']);

        return view('admin.hr.designations.show', compact('designation'));
    }

    public function edit(Designation $designation)
    {
        return view('admin.hr.designations.edit', compact('designation'));
    }

    public function update(Request $request, Designation $designation)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'name_ar' => 'nullable|string|max:255',
            'description' => 'nullable|string',
            'is_active' => 'boolean',
        ]);

        $designation->update($validated);

        return redirect()->route('admin.hr.designations.index')
            ->with('success', 'Designation updated successfully.');
    }

    public function destroy(Designation $designation)
    {
        $designation->delete();

        return redirect()->route('admin.hr.designations.index')
            ->with('success', 'Designation deleted successfully.');
    }
}
