<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\CustomerContact;
use App\Models\Customer;
use Illuminate\Http\Request;

class CustomerContactController extends Controller
{
    public function index()
    {
            
        $customerContacts = CustomerContact::with('customer')->get();
        return view('admin.customer_contacts.index', compact('customerContacts'));
    }

    public function create()
    {
        $customers = Customer::all();
        return view('admin.customer_contacts.create', compact('customers'));
    }

    public function store(Request $request)
    {
        CustomerContact::create($request->all());
        return redirect()->route('customer_contacts.index')->with('success', 'Contact added.');
    }

    public function edit(CustomerContact $customerContact)
    {
        $customers = Customer::all();
        return view('admin.customer_contacts.edit', compact('customerContact', 'customers'));
    }

    public function update(Request $request, CustomerContact $customerContact)
    {
        $customerContact->update($request->all());
        return redirect()->route('customer_contacts.index')->with('success', 'Contact updated.');
    }

    public function destroy(CustomerContact $customerContact)
    {
        $customerContact->delete();
        return redirect()->route('customer_contacts.index')->with('success', 'Contact deleted.');
    }
}
